/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import java.util.Map;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.activity.ExternalActivity;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.SignalMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signal
implements AtomicOperation {
    private static final Log log = Log.getLog(Signal.class.getName());
    String signalName;
    Map<String, Object> parameters;
    NodeImpl node;

    public Signal(String signalName, Map<String, Object> parameters, NodeImpl node) {
        this.signalName = signalName;
        this.parameters = parameters;
        this.node = node;
    }

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return execution.getNode().isSignalAsync();
    }

    @Override
    public void perform(ExecutionImpl execution) {
        if (execution.getName() != null) {
            log.debug(execution.toString() + " signals " + this.node);
        } else {
            log.debug("signalling " + this.node + ", signal=" + this.signalName);
        }
        ExternalActivity externalActivity = (ExternalActivity)this.node.getBehaviour();
        try {
            execution.setPropagation(ExecutionImpl.Propagation.UNSPECIFIED);
            externalActivity.signal(execution, this.signalName, this.parameters);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't signal " + this.node + ": " + e.getMessage(), e);
        }
        if (execution.getPropagation() == ExecutionImpl.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    public String toString() {
        return "signal(node)";
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return new SignalMessage(execution, this.signalName, this.node);
    }
}

