/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.TakeTransitionMessage;
import org.jbpm.pvm.model.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TakeTransition
implements AtomicOperation {
    private static Log log = Log.getLog(TakeTransition.class.getName());

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return execution.getNode().isLeaveAsync() || execution.getTransition().isTakeAsync();
    }

    @Override
    public void perform(ExecutionImpl execution) {
        TransitionImpl transition = execution.getTransition();
        if (execution.getName() != null) {
            log.debug(execution.toString() + " takes " + transition);
        } else {
            log.debug("taking " + transition);
        }
        List<NodeImpl> leftNodes = this.getNodesLeft(execution.getNode(), transition.getDestination());
        ExecutionImpl propagatingExecution = execution;
        for (NodeImpl leftNode : leftNodes) {
            propagatingExecution = propagatingExecution.endNode(leftNode);
        }
        propagatingExecution.setNode(null);
        propagatingExecution.fire("transition-take", transition);
        boolean wait = false;
        Condition waitCondition = transition.getWaitCondition();
        if (waitCondition != null) {
            wait = waitCondition.evaluate(propagatingExecution);
        }
        if (!wait) {
            propagatingExecution.performAtomicOperation(ExecutionImpl.PROCEED_TO_DESTINATION);
        }
    }

    List<NodeImpl> getNodesLeft(NodeImpl source, NodeImpl destination) {
        ArrayList<NodeImpl> nodesLeft = new ArrayList<NodeImpl>();
        if (source.equals(destination)) {
            nodesLeft.add(source);
        } else {
            List<ObservableElementImpl> destinationChain = destination.getParentChain();
            if (!destinationChain.contains(source)) {
                for (NodeImpl sourceNode = source; sourceNode != null && !destinationChain.contains(sourceNode); sourceNode = sourceNode.getParentNode()) {
                    nodesLeft.add(sourceNode);
                }
            }
        }
        return nodesLeft;
    }

    public String toString() {
        return "take-transition";
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return new TakeTransitionMessage(execution);
    }
}

