/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.util.FilterListener;
import org.jbpm.pvm.internal.util.Listener;
import org.jbpm.pvm.internal.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObservable
implements Observable {
    protected List<Listener> listeners = null;

    @Override
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new PvmException("listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new PvmException("listener is null");
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Listener addListener(Listener listener, String eventName) {
        if (eventName == null) {
            throw new PvmException("eventName is null");
        }
        ArrayList<String> eventNames = new ArrayList<String>();
        eventNames.add(eventName);
        return this.addListener(listener, eventNames);
    }

    @Override
    public Listener addListener(Listener listener, List<String> eventNames) {
        if (listener == null) {
            throw new PvmException("listener is null");
        }
        if (eventNames == null) {
            throw new PvmException("eventNames is null");
        }
        FilterListener filterListener = new FilterListener(listener, eventNames);
        this.addListener(filterListener);
        return filterListener;
    }

    @Override
    public void fire(String eventName) {
        this.fire(eventName, null);
    }

    @Override
    public void fire(String eventName, Object info) {
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                listener.event(this, eventName, info);
            }
        }
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }
}

