/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.util.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterListener
implements Listener {
    protected Listener listener;
    protected List<String> eventNames;

    public FilterListener(Listener listener, String eventName) {
        if (listener == null) {
            throw new PvmException("listener is null");
        }
        this.listener = listener;
        if (eventName == null) {
            throw new PvmException("eventName is null");
        }
        this.eventNames = new ArrayList<String>();
        this.eventNames.add(eventName);
    }

    public FilterListener(Listener listener, List<String> eventNames) {
        if (listener == null) {
            throw new PvmException("listener is null");
        }
        this.listener = listener;
        if (eventNames == null) {
            throw new PvmException("eventNames is null");
        }
        this.eventNames = eventNames;
    }

    @Override
    public void event(Object source, String name, Object info) {
        if (!this.isFiltered(name)) {
            this.listener.event(source, name, info);
        }
    }

    public boolean isFiltered(String eventName) {
        return !this.eventNames.contains(eventName);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return object instanceof Listener && this.listener.equals(object);
    }

    public int hashCode() {
        return 17 + this.listener.hashCode();
    }
}

