/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.List;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.WireOperationBinding;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.wire.operation.SubscribeOperation;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class SubscribeBinding
extends WireOperationBinding {
    public SubscribeBinding() {
        super("subscribe");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        SubscribeOperation subscribeOperation = new SubscribeOperation();
        String contextName = XmlUtil.attribute(element, "context");
        subscribeOperation.setContextName(contextName);
        String to = XmlUtil.attribute(element, "to");
        if ("wire-events".equalsIgnoreCase(to)) {
            subscribeOperation.setWireEvents(true);
        }
        List<String> eventNames = XmlUtil.parseList(element, "event");
        subscribeOperation.setEventNames(eventNames);
        List<String> objectNames = XmlUtil.parseList(element, "object");
        subscribeOperation.setObjectNames(objectNames);
        String methodName = XmlUtil.attribute(element, "method");
        subscribeOperation.setMethodName(methodName);
        List<Element> argElements = XmlUtil.elements(element, "arg");
        WireParser wireParser = (WireParser)parser;
        List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
        subscribeOperation.setArgDescriptors(argDescriptors);
        return subscribeOperation;
    }
}

