/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ContextTypeRefDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentTypeRefDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(ContextTypeRefDescriptor.class.getName());
    Class<?> type;

    public EnvironmentTypeRefDescriptor(Class<?> type) {
        this.type = type;
    }

    @Override
    public Object construct(WireContext wireContext) {
        log.trace("looking up " + this.type + " by type in environment");
        if (this.type != null) {
            Environment environment = Environment.getCurrent();
            if (environment == null) {
                throw new WireException("no environment to search an object of type " + this.type.getName());
            }
            return environment.get(this.type);
        }
        return null;
    }
}

