/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.test.base;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.EnvironmentFactory;
import org.jbpm.pvm.env.PvmEnvironmentFactory;
import org.jbpm.pvm.test.base.JbpmTestCase;

public abstract class EnvironmentFactoryTestCase
extends JbpmTestCase {
    String configResource;
    static Map<String, EnvironmentFactory> environmentFactories = new HashMap<String, EnvironmentFactory>();

    public EnvironmentFactoryTestCase() {
        this("environment.cfg.xml");
    }

    public EnvironmentFactoryTestCase(String configResource) {
        this.configResource = configResource;
    }

    public EnvironmentFactory getEnvironmentFactory() {
        if (this.isEnvironmentFactoryCached()) {
            return environmentFactories.get(this.configResource);
        }
        return this.createEnvironmentFactory();
    }

    boolean isEnvironmentFactoryCached() {
        return environmentFactories.containsKey(this.configResource);
    }

    EnvironmentFactory createEnvironmentFactory() {
        return EnvironmentFactoryTestCase.createEnvironmentFactory(this.configResource);
    }

    static EnvironmentFactory createEnvironmentFactory(String configResource) {
        try {
            log.debug("creating environment factory for [" + configResource + "]");
            PvmEnvironmentFactory newEnvironmentFactory = new PvmEnvironmentFactory(configResource);
            environmentFactories.put(configResource, newEnvironmentFactory);
            return newEnvironmentFactory;
        }
        catch (Exception e) {
            throw new PvmException("Exception during creation of environment factory for " + configResource, e);
        }
    }

    static void closeEnvironmentFactory(String configResource) {
        EnvironmentFactory environmentFactory = environmentFactories.remove(configResource);
        if (environmentFactory != null) {
            log.debug("closing environment factory for [" + configResource + "]");
            environmentFactory.close();
        }
    }
}

