/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStoreContextBuilder;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.util.Throwables2;

public class BlobStoreContextFactory {
    private final RestContextFactory contextFactory;

    public BlobStoreContextFactory() {
        this(new RestContextFactory());
    }

    public BlobStoreContextFactory(Properties properties) {
        this(new RestContextFactory(properties));
    }

    public BlobStoreContextFactory(RestContextFactory restContextFactory) {
        this.contextFactory = restContextFactory;
    }

    public static <S, A> BlobStoreContext buildContextUnwrappingExceptions(BlobStoreContextBuilder<S, A> builder) {
        try {
            return builder.buildBlobStoreContext();
        }
        catch (Exception e) {
            return (BlobStoreContext)Throwables2.propagateAuthorizationOrOriginalException((Exception)e);
        }
    }

    public BlobStoreContext createContext(String provider, String identity, String credential) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public BlobStoreContext createContext(String provider, Properties overrides) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, overrides)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public BlobStoreContext createContext(String provider, Iterable<? extends Module> modules, Properties overrides) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, modules, overrides)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public BlobStoreContext createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> modules) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential, modules)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public BlobStoreContext createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> modules, Properties overrides) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential, modules, overrides)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> BlobStoreContext createContext(RestContextSpec<S, A> contextSpec) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> BlobStoreContext createContext(RestContextSpec<S, A> contextSpec, Properties overrides) {
        BlobStoreContextBuilder builder = (BlobStoreContextBuilder)((Object)BlobStoreContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec, (Properties)overrides)));
        return BlobStoreContextFactory.buildContextUnwrappingExceptions(builder);
    }
}

