/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

public class PutOptions
implements Cloneable {
    public static final ImmutablePutOptions NONE = new ImmutablePutOptions(new PutOptions());
    private boolean multipart = false;

    public PutOptions() {
    }

    public PutOptions(boolean multipart) {
        this.multipart = multipart;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public PutOptions multipart() {
        this.multipart = true;
        return this;
    }

    public PutOptions clone() {
        return new PutOptions(this.multipart);
    }

    public String toString() {
        return "[multipart=" + this.multipart + "]";
    }

    public static class Builder {
        public static PutOptions multipart() {
            PutOptions options = new PutOptions();
            return options.multipart();
        }
    }

    public static class ImmutablePutOptions
    extends PutOptions {
        private final PutOptions delegate;

        public ImmutablePutOptions(PutOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isMultipart() {
            return this.delegate.isMultipart();
        }

        @Override
        public PutOptions multipart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PutOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

