/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.reflect.Reflection2;

public abstract class BaseApiMetadata
implements ApiMetadata {
    private final String id;
    private final String name;
    private final Set<TypeToken<? extends View>> views;
    private final String endpointName;
    private final String identityName;
    private final Optional<String> credentialName;
    private final String version;
    private final Optional<String> buildVersion;
    private final Optional<String> defaultEndpoint;
    private final Optional<String> defaultIdentity;
    private final Optional<String> defaultCredential;
    private final Properties defaultProperties;
    private final URI documentation;
    private final TypeToken<? extends Context> context;
    private final Set<Class<? extends Module>> defaultModules;

    public static Properties defaultProperties() {
        Properties props = new Properties();
        props.setProperty("jclouds.iso3166-codes", "");
        props.setProperty("jclouds.max-connections-per-context", "20");
        props.setProperty("jclouds.max-connections-per-host", "0");
        props.setProperty("jclouds.so-timeout", "60000");
        props.setProperty("jclouds.connection-timeout", "60000");
        props.setProperty("jclouds.io-worker-threads", "20");
        props.setProperty("jclouds.user-threads", "0");
        props.setProperty("jclouds.scheduler-threads", "10");
        props.setProperty("jclouds.max-connection-reuse", "75");
        props.setProperty("jclouds.max-session-failures", "2");
        props.setProperty("jclouds.session-interval", "60");
        props.setProperty("jclouds.payloads.pretty-print", "true");
        return props;
    }

    protected BaseApiMetadata(Builder<?> builder) {
        this(((Builder)builder).id, ((Builder)builder).name, ((Builder)builder).views, ((Builder)builder).endpointName, ((Builder)builder).identityName, (Optional<String>)((Builder)builder).credentialName, ((Builder)builder).version, (Optional<String>)((Builder)builder).buildVersion, (Optional<String>)((Builder)builder).defaultEndpoint, (Optional<String>)((Builder)builder).defaultIdentity, (Optional<String>)((Builder)builder).defaultCredential, ((Builder)builder).defaultProperties, ((Builder)builder).documentation, (TypeToken<? extends Context>)((Builder)builder).context, ((Builder)builder).defaultModules);
    }

    protected BaseApiMetadata(String id, String name, Set<TypeToken<? extends View>> views, String endpointName, String identityName, Optional<String> credentialName, String version, Optional<String> buildVersion, Optional<String> defaultEndpoint, Optional<String> defaultIdentity, Optional<String> defaultCredential, Properties defaultProperties, URI documentation, TypeToken<? extends Context> context, Set<Class<? extends Module>> defaultModules) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.views = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(views, (Object)"views")));
        this.endpointName = (String)Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName");
        this.identityName = (String)Preconditions.checkNotNull((Object)identityName, (Object)"identityName");
        this.credentialName = (Optional)Preconditions.checkNotNull(credentialName, (Object)"credentialName");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.buildVersion = (Optional)Preconditions.checkNotNull(buildVersion, (Object)"buildVersion");
        this.defaultEndpoint = (Optional)Preconditions.checkNotNull(defaultEndpoint, (Object)"defaultEndpoint");
        this.defaultIdentity = (Optional)Preconditions.checkNotNull(defaultIdentity, (Object)"defaultIdentity");
        this.defaultCredential = (Optional)Preconditions.checkNotNull(defaultCredential, (Object)"defaultCredential");
        this.defaultProperties = (Properties)Preconditions.checkNotNull((Object)defaultProperties, (Object)"defaultProperties");
        this.documentation = (URI)Preconditions.checkNotNull((Object)documentation, (Object)"documentation");
        this.context = (TypeToken)Preconditions.checkNotNull(context, (Object)"context");
        this.defaultModules = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(defaultModules, (Object)"defaultModules")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApiMetadata)) {
            return false;
        }
        ApiMetadata that = (ApiMetadata)ApiMetadata.class.cast(o);
        return Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal(this.getViews(), that.getViews());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName(), this.getViews()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("views", this.getViews()).add("endpointName", (Object)this.getEndpointName()).add("identityName", (Object)this.getIdentityName()).add("credentialName", this.getCredentialName()).add("documentation", (Object)this.getDocumentation());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<TypeToken<? extends View>> getViews() {
        return this.views;
    }

    @Override
    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public String getIdentityName() {
        return this.identityName;
    }

    @Override
    public Optional<String> getCredentialName() {
        return this.credentialName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    public Optional<String> getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public Optional<String> getDefaultIdentity() {
        return this.defaultIdentity;
    }

    @Override
    public Optional<String> getDefaultCredential() {
        return this.defaultCredential;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public URI getDocumentation() {
        return this.documentation;
    }

    @Override
    public TypeToken<? extends Context> getContext() {
        return this.context;
    }

    @Override
    public Set<Class<? extends Module>> getDefaultModules() {
        return this.defaultModules;
    }

    public static abstract class Builder<T extends Builder<T>>
    implements ApiMetadata.Builder<T> {
        private String id;
        private String name;
        private Set<TypeToken<? extends View>> views = ImmutableSet.of();
        private String endpointName = "https endpoint";
        private String identityName;
        private Optional<String> credentialName = Optional.absent();
        private String version = "";
        private Optional<String> buildVersion = Optional.of((Object)"");
        private Optional<String> defaultEndpoint = Optional.absent();
        private Optional<String> defaultIdentity = Optional.absent();
        private Optional<String> defaultCredential = Optional.absent();
        private Properties defaultProperties = BaseApiMetadata.defaultProperties();
        private URI documentation;
        private TypeToken<? extends Context> context = Reflection2.typeToken(Context.class);
        private Set<Class<? extends Module>> defaultModules = ImmutableSet.of();

        protected abstract T self();

        @Override
        public T id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this.self();
        }

        @Override
        public T name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this.self();
        }

        @Override
        public T view(Class<? extends View> view) {
            return (T)this.view(Reflection2.typeToken((Class)Preconditions.checkNotNull(view, (Object)"view")));
        }

        @Override
        public T view(TypeToken<? extends View> view) {
            return (T)this.views((Set)ImmutableSet.of((Object)Preconditions.checkNotNull(view, (Object)"view")));
        }

        @Override
        public T views(Set<TypeToken<? extends View>> views) {
            this.views = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(views, (Object)"views")));
            return this.self();
        }

        @Override
        public T endpointName(String endpointName) {
            this.endpointName = (String)Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName");
            return this.self();
        }

        @Override
        public T identityName(String identityName) {
            this.identityName = (String)Preconditions.checkNotNull((Object)identityName, (Object)"identityName");
            return this.self();
        }

        @Override
        public T credentialName(String credentialName) {
            this.credentialName = Optional.fromNullable((Object)credentialName);
            return this.self();
        }

        @Override
        public T version(String version) {
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            return this.self();
        }

        @Override
        public T buildVersion(String buildVersion) {
            this.buildVersion = Optional.fromNullable((Object)buildVersion);
            return this.self();
        }

        @Override
        public T defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = Optional.fromNullable((Object)defaultEndpoint);
            return this.self();
        }

        @Override
        public T defaultIdentity(String defaultIdentity) {
            this.defaultIdentity = Optional.fromNullable((Object)defaultIdentity);
            return this.self();
        }

        @Override
        public T defaultCredential(String defaultCredential) {
            this.defaultCredential = Optional.fromNullable((Object)defaultCredential);
            return this.self();
        }

        @Override
        public T defaultProperties(Properties defaultProperties) {
            this.defaultProperties = (Properties)Preconditions.checkNotNull((Object)defaultProperties, (Object)"defaultProperties");
            return this.self();
        }

        @Override
        public T documentation(URI documentation) {
            this.documentation = (URI)Preconditions.checkNotNull((Object)documentation, (Object)"documentation");
            return this.self();
        }

        @Override
        public T context(TypeToken<? extends Context> context) {
            this.context = (TypeToken)Preconditions.checkNotNull(context, (Object)"context");
            return this.self();
        }

        @Override
        public T defaultModule(Class<? extends Module> defaultModule) {
            return (T)this.defaultModules((Set)ImmutableSet.of((Object)Preconditions.checkNotNull(defaultModule, (Object)"defaultModule")));
        }

        @Override
        public T defaultModules(Set<Class<? extends Module>> defaultModules) {
            this.defaultModules = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(defaultModules, (Object)"defaultModules")));
            return this.self();
        }

        @Override
        public T fromApiMetadata(ApiMetadata in) {
            return (T)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).views((Set)in.getViews())).name(in.getName())).endpointName(in.getEndpointName())).identityName(in.getIdentityName())).credentialName((String)in.getCredentialName().orNull())).version(in.getVersion())).buildVersion((String)in.getBuildVersion().orNull())).defaultEndpoint((String)in.getDefaultEndpoint().orNull())).defaultIdentity((String)in.getDefaultIdentity().orNull())).defaultCredential((String)in.getDefaultCredential().orNull())).defaultProperties(in.getDefaultProperties())).documentation(in.getDocumentation())).context((TypeToken)in.getContext())).defaultModules((Set)in.getDefaultModules());
        }
    }
}

