/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.annotations.Beta;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import java.util.Map;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateService;
import org.jclouds.domain.Credentials;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.internal.UtilsImpl;
import org.jclouds.xml.XMLParser;

@ImplementedBy(value=UtilsImpl.class)
public interface Utils {
    @Beta
    public Map<String, Credentials> getCredentialStore();

    @Beta
    public Map<String, Credentials> credentialStore();

    public Json getJson();

    public Json json();

    public HttpAsyncClient getHttpAsyncClient();

    public HttpAsyncClient asyncHttp();

    public HttpClient getHttpClient();

    public HttpClient http();

    public Crypto getCrypto();

    public Crypto crypto();

    public DateService getDateService();

    public DateService date();

    public ListeningExecutorService getUserExecutor();

    public ListeningExecutorService userExecutor();

    public ListeningExecutorService getIoExecutor();

    public ListeningExecutorService ioExecutor();

    @Beta
    public EventBus getEventBus();

    public EventBus eventBus();

    public Logger.LoggerFactory getLoggerFactory();

    public Logger.LoggerFactory loggerFactory();

    @Beta
    public Injector getInjector();

    @Beta
    public Injector injector();

    public XMLParser getXml();

    public XMLParser xml();
}

