/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.DelegatesToInvocationFunction;

@Singleton
public class AsyncHttpApiProvider<A>
implements Provider<A> {
    private final Class<? super A> asyncApiType;
    private final DelegatesToInvocationFunction<A, Function<Invocation, Object>> httpInvoker;

    @Inject
    private AsyncHttpApiProvider(DelegatesToInvocationFunction<A, Function<Invocation, Object>> httpInvoker, TypeLiteral<A> asyncApiType) {
        this.httpInvoker = httpInvoker;
        this.asyncApiType = asyncApiType.getRawType();
    }

    public A get() {
        return (A)Proxy.newProxyInstance(this.asyncApiType.getClassLoader(), new Class[]{this.asyncApiType}, this.httpInvoker);
    }
}

