/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.cache.Cache;
import com.google.common.reflect.Invokable;
import com.google.inject.Provider;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.config.RestModule;
import org.jclouds.rest.internal.DelegatesToInvocationFunction;
import org.jclouds.rest.internal.InvokeAndCallGetOnFutures;

@Singleton
public class CallGetOnFuturesProvider<S, A>
implements Provider<S> {
    private final Class<? super S> apiType;
    private final DelegatesToInvocationFunction<S, InvokeAndCallGetOnFutures<A>> syncInvoker;

    @Inject
    private CallGetOnFuturesProvider(Cache<Invokable<?, ?>, Invokable<?, ?>> invokables, DelegatesToInvocationFunction<S, InvokeAndCallGetOnFutures<A>> syncInvoker, Class<S> apiType, Class<A> asyncApiType) {
        this.syncInvoker = syncInvoker;
        this.apiType = apiType;
        RestModule.putInvokables(apiType, asyncApiType, invokables);
    }

    @Singleton
    public S get() {
        return (S)Proxy.newProxyInstance(this.apiType.getClassLoader(), new Class[]{this.apiType}, this.syncInvoker);
    }
}

