/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.util.concurrent.Atomics;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.jclouds.Fallback;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.config.LocationModule;
import org.jclouds.proxy.ProxyForURI;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.SetCaller;
import org.jclouds.rest.internal.InvokeHttpMethod;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.rest.internal.TransformerForRequest;

public class RestModule
extends AbstractModule {
    public static final TypeLiteral<Supplier<URI>> URI_SUPPLIER_TYPE = new TypeLiteral<Supplier<URI>>(){};
    protected final Map<Class<?>, Class<?>> sync2Async;
    protected final AtomicReference<AuthorizationException> authException = Atomics.newReference();

    public RestModule() {
        this((Map<Class<?>, Class<?>>)ImmutableMap.of());
    }

    public RestModule(Map<Class<?>, Class<?>> sync2Async) {
        this.sync2Async = sync2Async;
    }

    @Provides
    @Singleton
    protected Cache<Invokable<?, ?>, Invokable<?, ?>> seedKnownSync2AsyncInvokables() {
        return RestModule.seedKnownSync2AsyncInvokables(this.sync2Async);
    }

    @Provides
    @Singleton
    protected Function<Invocation, Invocation> sync2async(final Cache<Invokable<?, ?>, Invokable<?, ?>> cache) {
        return new Function<Invocation, Invocation>(){

            public Invocation apply(Invocation in) {
                return Invocation.create((Invokable)Preconditions.checkNotNull((Object)cache.getIfPresent(in.getInvokable()), (String)"invokable %s not in %s", (Object[])new Object[]{in.getInvokable(), cache}), in.getArgs());
            }
        };
    }

    @VisibleForTesting
    static Cache<Invokable<?, ?>, Invokable<?, ?>> seedKnownSync2AsyncInvokables(Map<Class<?>, Class<?>> sync2Async) {
        Cache sync2AsyncBuilder = CacheBuilder.newBuilder().build();
        RestModule.putInvokables(HttpClient.class, HttpAsyncClient.class, sync2AsyncBuilder);
        for (Map.Entry<Class<?>, Class<?>> entry : sync2Async.entrySet()) {
            RestModule.putInvokables(entry.getKey(), entry.getValue(), sync2AsyncBuilder);
        }
        return sync2AsyncBuilder;
    }

    public static void putInvokables(Class<?> sync, Class<?> async, Cache<Invokable<?, ?>, Invokable<?, ?>> cache) {
        for (Invokable<?, Object> invoked : Reflection2.methods(sync)) {
            Invokable delegatedMethod = Reflection2.method(async, invoked.getName(), RestModule.getParameterTypes(invoked));
            Preconditions.checkArgument((boolean)delegatedMethod.getExceptionTypes().equals((Object)invoked.getExceptionTypes()), (String)"invoked %s has different typed exceptions than target %s", (Object[])new Object[]{invoked, delegatedMethod});
            cache.put(invoked, delegatedMethod);
        }
    }

    private static Class<?>[] getParameterTypes(Invokable<?, ?> in) {
        return (Class[])Iterables.toArray((Iterable)Iterables.transform((Iterable)((Invokable)Preconditions.checkNotNull(in, (Object)"invokable")).getParameters(), (Function)new Function<Parameter, Class<?>>(){

            public Class<?> apply(Parameter input) {
                return input.getType().getRawType();
            }
        }), Class.class);
    }

    protected void installLocations() {
        this.install((Module)new LocationModule());
    }

    protected void configure() {
        this.bind(new TypeLiteral<Map<Class<?>, Class<?>>>(){}).toInstance(this.sync2Async);
        this.install((Module)new SaxParserModule());
        this.install((Module)new GsonModule());
        this.install((Module)new SetCaller.Module());
        this.install(new FactoryModuleBuilder().build(BindToJsonPayloadWrappedWith.Factory.class));
        this.bind(new TypeLiteral<Function<HttpRequest, Function<HttpResponse, ?>>>(){}).to(TransformerForRequest.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Invocation, Object>>(){}).to(InvokeHttpMethod.class);
        this.bind((TypeLiteral)new TypeLiteral<Fallback<Object>>(){}).to(MapHttp4xxCodesToExceptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Invocation, HttpRequest>>(){}).to(RestAnnotationProcessor.class);
        this.bind(IdentityFunction.class).toInstance((Object)IdentityFunction.INSTANCE);
        BinderUtils.bindHttpApi(this.binder(), HttpClient.class, HttpAsyncClient.class);
        this.bind((TypeLiteral)new TypeLiteral<AtomicReference<AuthorizationException>>(){}).toInstance(this.authException);
        this.bind((TypeLiteral)new TypeLiteral<Function<Predicate<String>, Map<String, String>>>(){}).to(FilterStringsBoundToInjectorByName.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<URI, Proxy>>(){}).to(ProxyForURI.class);
        this.installLocations();
    }
}

