/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.reflect.FunctionalReflection;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.config.SetCaller;
import org.jclouds.util.Optionals2;
import org.jclouds.util.Throwables2;

@Beta
public final class DelegatesToInvocationFunction<S, F extends Function<Invocation, Object>>
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private final Injector injector;
    private final TypeToken<S> ownerType;
    private final SetCaller setCaller;
    private final Map<Class<?>, Class<?>> syncToAsync;
    private final Function<InvocationSuccess, Optional<Object>> optionalConverter;
    private final F methodInvoker;
    static final Predicate<Annotation> isQualifierPresent = new Predicate<Annotation>(){

        public boolean apply(Annotation input) {
            return input.annotationType().isAnnotationPresent(Qualifier.class);
        }
    };

    @Override
    public final Object invoke(Object proxy, Method invoked, @Nullable Object[] argv) throws Throwable {
        if (argv == null) {
            argv = NO_ARGS;
        }
        if (argv.length == 0 && invoked.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (argv.length == 1 && invoked.getName().equals("equals") && invoked.getParameterTypes()[0] == Object.class) {
            Object arg = argv[0];
            return proxy.getClass().isInstance(arg) && this.equals(Proxy.getInvocationHandler(arg));
        }
        if (argv.length == 0 && invoked.getName().equals("toString")) {
            return this.toString();
        }
        Object args = Arrays.asList(argv);
        args = Iterables.all(args, (Predicate)Predicates.notNull()) ? ImmutableList.copyOf(args) : Collections.unmodifiableList(args);
        Invokable invokable = Reflection2.method(this.ownerType, invoked);
        Invocation invocation = Invocation.create(invokable, (List<Object>)args);
        try {
            return this.handle(invocation);
        }
        catch (Throwable e) {
            Throwables2.propagateIfPossible(e, (Iterable<TypeToken<? extends Throwable>>)invocation.getInvokable().getExceptionTypes());
            throw e;
        }
    }

    protected Object handle(Invocation invocation) {
        if (invocation.getInvokable().isAnnotationPresent(Provides.class)) {
            return this.lookupValueFromGuice(invocation.getInvokable());
        }
        if (invocation.getInvokable().isAnnotationPresent(Delegate.class)) {
            return this.propagateContextToDelegate(invocation);
        }
        return this.methodInvoker.apply((Object)invocation);
    }

    @Inject
    DelegatesToInvocationFunction(Injector injector, SetCaller setCaller, Map<Class<?>, Class<?>> syncToAsync, Class<S> ownerType, Function<InvocationSuccess, Optional<Object>> optionalConverter, F methodInvoker) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector");
        this.ownerType = Reflection2.typeToken((Class)Preconditions.checkNotNull(ownerType, (Object)"ownerType"));
        this.setCaller = (SetCaller)Preconditions.checkNotNull((Object)setCaller, (Object)"setCaller");
        this.syncToAsync = (Map)Preconditions.checkNotNull(syncToAsync, (Object)"syncToAsync");
        this.optionalConverter = (Function)Preconditions.checkNotNull(optionalConverter, (Object)"optionalConverter");
        this.methodInvoker = (Function)Preconditions.checkNotNull(methodInvoker, (Object)"methodInvoker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object propagateContextToDelegate(Invocation caller) {
        Function delegate;
        Class<?> returnType = Optionals2.unwrapIfOptional(caller.getInvokable().getReturnType());
        this.setCaller.enter(caller);
        try {
            Key<?> delegateType = this.methodInvokerFor(returnType);
            delegate = (Function)this.injector.getInstance(delegateType);
        }
        finally {
            this.setCaller.exit();
        }
        Object result = FunctionalReflection.newProxy(returnType, (Function<Invocation, Object>)delegate);
        if (Optionals2.isReturnTypeOptional(caller.getInvokable())) {
            result = this.optionalConverter.apply((Object)InvocationSuccess.create(caller, result));
        }
        return result;
    }

    private Key<?> methodInvokerFor(Class<?> returnType) {
        switch (this.methodInvoker.getClass().getTypeParameters().length) {
            case 0: {
                return Key.get(this.methodInvoker.getClass());
            }
            case 1: {
                return Key.get((Type)Types.newParameterizedType(this.methodInvoker.getClass(), (Type[])new Type[]{returnType}));
            }
            case 2: {
                if (this.syncToAsync.containsValue(returnType)) {
                    return Key.get((Type)Types.newParameterizedType(this.methodInvoker.getClass(), (Type[])new Type[]{returnType, returnType}));
                }
                return Key.get((Type)Types.newParameterizedType(this.methodInvoker.getClass(), (Type[])new Type[]{returnType, (Type)Preconditions.checkNotNull(this.syncToAsync.get(returnType), (String)"need async type of %s for %s", (Object[])new Object[]{returnType, this.methodInvoker.getClass()})}));
            }
        }
        throw new IllegalArgumentException(returnType + " has too many type parameters");
    }

    private Object lookupValueFromGuice(Invokable<?, ?> invoked) {
        try {
            Type genericReturnType = invoked.getReturnType().getType();
            try {
                Annotation qualifier = (Annotation)Iterables.find((Iterable)ImmutableList.copyOf((Object[])invoked.getAnnotations()), isQualifierPresent);
                return this.getInstanceOfTypeWithQualifier(genericReturnType, qualifier);
            }
            catch (ProvisionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (RuntimeException e) {
                return this.instanceOfTypeOrPropagate(genericReturnType, e);
            }
        }
        catch (ProvisionException e) {
            AuthorizationException aex = Throwables2.getFirstThrowableOfType((Throwable)e, AuthorizationException.class);
            if (aex != null) {
                throw aex;
            }
            throw e;
        }
    }

    Object instanceOfTypeOrPropagate(Type genericReturnType, RuntimeException e) {
        try {
            Binding binding = this.injector.getExistingBinding(Key.get((Type)genericReturnType));
            if (binding != null) {
                return binding.getProvider().get();
            }
            binding = this.injector.getExistingBinding(Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{genericReturnType})));
            if (binding != null) {
                return ((Supplier)Supplier.class.cast(binding.getProvider().get())).get();
            }
            return this.injector.getInstance(Key.get((Type)genericReturnType));
        }
        catch (ConfigurationException ce) {
            throw e;
        }
    }

    Object getInstanceOfTypeWithQualifier(Type genericReturnType, Annotation qualifier) {
        Binding binding = this.injector.getExistingBinding(Key.get((Type)genericReturnType, (Annotation)qualifier));
        if (binding != null) {
            return binding.getProvider().get();
        }
        binding = this.injector.getExistingBinding(Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{genericReturnType}), (Annotation)qualifier));
        if (binding != null) {
            return ((Supplier)Supplier.class.cast(binding.getProvider().get())).get();
        }
        return this.injector.getInstance(Key.get((Type)genericReturnType, (Annotation)qualifier));
    }

    public String toString() {
        return Objects.toStringHelper((String)"").omitNullValues().add("ownerType", (Object)this.ownerType.getRawType().getSimpleName()).add("methodInvoker", this.methodInvoker).toString();
    }
}

