/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.concurrent.Callable;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;

class LazyHandleSupplier
implements HandleSupplier,
AutoCloseable {
    private final Jdbi db;
    private final ThreadLocal<ConfigRegistry> config;
    private final ThreadLocal<ExtensionMethod> extensionMethod = new ThreadLocal();
    private volatile Handle handle;
    private volatile boolean closed = false;

    LazyHandleSupplier(Jdbi db, ConfigRegistry config) {
        this.db = db;
        this.config = ThreadLocal.withInitial(() -> config);
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config.get();
    }

    @Override
    public Handle getHandle() {
        if (this.handle == null) {
            this.initHandle();
        }
        return this.handle;
    }

    private synchronized void initHandle() {
        if (this.handle == null) {
            if (this.closed) {
                throw new IllegalStateException("Handle is closed");
            }
            Handle handle = this.db.open();
            handle.setExtensionMethodThreadLocal(this.extensionMethod);
            handle.setConfigThreadLocal(this.config);
            this.handle = handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
        ExtensionMethod oldExtensionMethod = this.extensionMethod.get();
        try {
            V v;
            this.extensionMethod.set(extensionMethod);
            ConfigRegistry oldConfig = this.config.get();
            try {
                this.config.set(config);
                v = task.call();
                this.config.set(oldConfig);
            }
            catch (Throwable throwable) {
                this.config.set(oldConfig);
                throw throwable;
            }
            return v;
        }
        finally {
            this.extensionMethod.set(oldExtensionMethod);
        }
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.handle != null) {
            this.handle.close();
        }
        this.config.remove();
        this.extensionMethod.remove();
    }
}

