/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.jdbi.v3.core.argument.MethodReturnValueNamedArgumentFinder;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;

public class ObjectMethodArguments
extends MethodReturnValueNamedArgumentFinder {
    private static final Map<Class<?>, Map<String, Method>> CLASS_METHODS = ExpiringMap.builder().expiration(10L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).entryLoader(type -> Stream.of(type.getMethods()).filter(m -> m.getParameterCount() == 0).collect(Collectors.toMap(Method::getName, Function.identity()))).build();
    private final Map<String, Method> methods;

    public ObjectMethodArguments(String prefix, Object object) {
        super(prefix, object);
        this.methods = CLASS_METHODS.get(object.getClass());
    }

    @Override
    Optional<ObjectPropertyNamedArgumentFinder.TypedValue> getValue(String name, StatementContext ctx) {
        Method method = this.methods.get(name);
        if (method == null) {
            return Optional.empty();
        }
        Type type = method.getGenericReturnType();
        Object value = this.invokeMethod(method, ctx);
        return Optional.of(new ObjectPropertyNamedArgumentFinder.TypedValue(type, value));
    }

    @Override
    NamedArgumentFinder getNestedArgumentFinder(Object obj) {
        return new ObjectMethodArguments(null, obj);
    }

    public String toString() {
        return "{lazy object functions arguments \"" + this.object + "\"";
    }
}

