/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.core.statement.StatementContext;

class SqlArrayArgument<T>
implements Argument {
    private final String typeName;
    private final Object[] array;

    SqlArrayArgument(SqlArrayType<T> arrayType, Object newArray) {
        this.typeName = arrayType.getTypeName();
        ArrayList elements = new ArrayList(newArray.getClass().isArray() ? Array.getLength(newArray) : 10);
        IterableLike.of(newArray).forEachRemaining(e -> elements.add(arrayType.convertArrayElement(e)));
        this.array = elements.toArray();
    }

    SqlArrayArgument(SqlArrayType<T> arrayType, Collection<T> list) {
        this.typeName = arrayType.getTypeName();
        this.array = list.stream().map(arrayType::convertArrayElement).toArray();
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        SqlArrayArgumentStrategy argumentStyle = ctx.getSqlArrayArgumentStrategy();
        switch (argumentStyle) {
            case SQL_ARRAY: {
                java.sql.Array sqlArray = statement.getConnection().createArrayOf(this.typeName, this.array);
                ctx.addCleanable(sqlArray::free);
                statement.setArray(position, sqlArray);
                break;
            }
            case OBJECT_ARRAY: {
                statement.setObject(position, this.array);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown array argument style " + (Object)((Object)argumentStyle));
            }
        }
    }
}

