/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.array.InferredSqlArrayTypeFactory;
import org.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypeFactory;
import org.jdbi.v3.core.array.VendorSupportedArrayType;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.JdbiStreams;

public class SqlArrayTypes
implements JdbiConfig<SqlArrayTypes> {
    private final List<SqlArrayTypeFactory> factories = new CopyOnWriteArrayList<SqlArrayTypeFactory>();
    private SqlArrayArgumentStrategy argumentStrategy = SqlArrayArgumentStrategy.SQL_ARRAY;
    private ConfigRegistry registry;

    public SqlArrayTypes() {
        this.argumentStrategy = SqlArrayArgumentStrategy.SQL_ARRAY;
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private SqlArrayTypes(SqlArrayTypes that) {
        this.factories.addAll(that.factories);
        this.argumentStrategy = that.argumentStrategy;
    }

    public SqlArrayArgumentStrategy getArgumentStrategy() {
        return this.argumentStrategy;
    }

    public SqlArrayTypes setArgumentStrategy(SqlArrayArgumentStrategy argumentStrategy) {
        this.argumentStrategy = argumentStrategy;
        return this;
    }

    public SqlArrayTypes register(Class<?> elementType, String sqlTypeName) {
        return this.register(VendorSupportedArrayType.factory(elementType, sqlTypeName));
    }

    public SqlArrayTypes register(SqlArrayType<?> arrayType) {
        return this.register(new InferredSqlArrayTypeFactory(arrayType));
    }

    public SqlArrayTypes register(SqlArrayTypeFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<SqlArrayType<?>> findFor(Type elementType) {
        return this.factories.stream().flatMap(factory -> JdbiStreams.toStream(factory.build(elementType, this.registry))).findFirst();
    }

    @Override
    public SqlArrayTypes createCopy() {
        return new SqlArrayTypes(this);
    }
}

