/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.collector;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.ArrayCollectorFactory;
import org.jdbi.v3.core.collector.BuiltInCollectorFactory;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.config.JdbiConfig;

public class JdbiCollectors
implements JdbiConfig<JdbiCollectors> {
    private final List<CollectorFactory> factories = new CopyOnWriteArrayList<CollectorFactory>();

    public JdbiCollectors() {
        this.register(new BuiltInCollectorFactory());
        this.register(new ArrayCollectorFactory());
    }

    private JdbiCollectors(JdbiCollectors that) {
        this.factories.addAll(that.factories);
    }

    public JdbiCollectors register(CollectorFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<Collector<?, ?, ?>> findFor(Type containerType) {
        return this.findFactoryFor(containerType).map(f -> f.build(containerType));
    }

    public Optional<Type> findElementTypeFor(Type containerType) {
        return this.findFactoryFor(containerType).flatMap(f -> f.elementType(containerType));
    }

    private Optional<CollectorFactory> findFactoryFor(Type containerType) {
        return this.factories.stream().filter(f -> f.accepts(containerType)).findFirst();
    }

    @Override
    public JdbiCollectors createCopy() {
        return new JdbiCollectors(this);
    }
}

