/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IterableLike {
    public static boolean isIterable(Object maybeIterable) {
        return maybeIterable instanceof Iterator || maybeIterable instanceof Iterable || maybeIterable.getClass().isArray();
    }

    public static Iterator<Object> of(Object iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("can't iterate null");
        }
        if (iterable instanceof Iterator) {
            return (Iterator)iterable;
        }
        if (iterable instanceof Iterable) {
            return ((Iterable)iterable).iterator();
        }
        Class<?> klass = iterable.getClass();
        if (!klass.isArray()) {
            throw new IllegalArgumentException(IterableLike.getTypeWarning(klass));
        }
        if (klass.getComponentType().isPrimitive()) {
            return new PrimitiveArrayIterator(iterable);
        }
        return Arrays.asList((Object[])iterable).iterator();
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("cannot determine emptiness of null");
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        throw new IllegalArgumentException(IterableLike.getTypeWarning(obj.getClass()));
    }

    public static List<Object> toList(Object iterable) {
        ArrayList<Object> result = new ArrayList<Object>();
        IterableLike.of(iterable).forEachRemaining(result::add);
        return result;
    }

    private static String getTypeWarning(Class<?> type) {
        return "argument must be one of the following: Iterable, or an array/varargs (primitive or complex type); was " + type.getName() + " instead";
    }

    static class PrimitiveArrayIterator
    implements Iterator<Object> {
        private int index = 0;
        private final int size;
        private final Object arr;

        PrimitiveArrayIterator(Object obj) {
            this.size = Array.getLength(obj);
            this.arr = obj;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return Array.get(this.arr, this.index++);
            }
            throw new NoSuchElementException("only " + this.size + " elements available");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

