/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

public abstract class AbstractArgumentFactory<T>
implements ArgumentFactory {
    private final int sqlType;
    private final ArgumentPredicate isInstance;

    protected AbstractArgumentFactory(int sqlType) {
        this.sqlType = sqlType;
        Type argumentType = GenericTypes.findGenericParameter(this.getClass(), AbstractArgumentFactory.class).orElseThrow(() -> new IllegalStateException(this.getClass().getSimpleName() + " must extend AbstractArgumentFactory with a concrete T parameter"));
        if (argumentType instanceof Class) {
            Class argumentClass = (Class)argumentType;
            this.isInstance = (type, value) -> argumentClass.isAssignableFrom(GenericTypes.getErasedType(type)) || argumentClass.isInstance(value);
        } else {
            this.isInstance = (type, value) -> argumentType.equals(type);
        }
    }

    @Override
    public final Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        if (!this.isInstance.test(type, value)) {
            return Optional.empty();
        }
        return Optional.of(value == null ? new NullArgument(this.sqlType) : this.build(value, config));
    }

    protected abstract Argument build(T var1, ConfigRegistry var2);

    private static interface ArgumentPredicate {
        public boolean test(Type var1, Object var2);
    }
}

