/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.jdbi.v3.core.internal.lexer.DefineStatementLexer;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.internal.ErrorListener;

public class DefinedAttributeTemplateEngine
implements TemplateEngine {
    @Override
    public String render(String template, StatementContext ctx) {
        StringBuilder b = new StringBuilder();
        DefineStatementLexer lexer = new DefineStatementLexer((CharStream)CharStreams.fromString((String)template));
        lexer.addErrorListener(new ErrorListener());
        try {
            Token t = lexer.nextToken();
            while (t.getType() != -1) {
                switch (t.getType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        b.append(t.getText());
                        break;
                    }
                    case 5: {
                        String text = t.getText();
                        String key = text.substring(1, text.length() - 1);
                        Object value = ctx.getAttribute(key);
                        if (value == null) {
                            throw new UnableToCreateStatementException("Undefined attribute for token '" + text + "'", ctx);
                        }
                        b.append(value);
                        break;
                    }
                    case 4: {
                        b.append(t.getText().substring(1));
                        break;
                    }
                }
                t = lexer.nextToken();
            }
            return b.toString();
        }
        catch (RuntimeException e) {
            throw new UnableToCreateStatementException("Error rendering SQL template: '" + template + "'", e, ctx);
        }
    }
}

