/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.Tuple2;
import io.vavr.collection.Map;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.generic.internal.TypeParameter;
import org.jdbi.v3.core.generic.internal.TypeToken;

class VavrGenericMapUtil {
    private static final TypeVariable<Class<Map>> KEY;
    private static final TypeVariable<Class<Map>> VALUE;

    VavrGenericMapUtil() {
    }

    static Type resolveMapEntryType(Type mapType) {
        Type keyType = GenericTypes.resolveType(KEY, (Type)mapType);
        Type valueType = GenericTypes.resolveType(VALUE, (Type)mapType);
        return VavrGenericMapUtil.resolveMapEntryType(keyType, valueType);
    }

    private static Type resolveMapEntryType(Type keyType, Type valueType) {
        return VavrGenericMapUtil.resolveMapEntryType(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType));
    }

    private static <K, V> Type resolveMapEntryType(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Tuple2<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
    }

    static {
        TypeVariable<Class<T>>[] mapParams = Map.class.getTypeParameters();
        KEY = mapParams[0];
        VALUE = mapParams[1];
    }
}

