/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.HashMap;
import java.util.Map;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngineListener;
import org.jeasy.rules.core.AbstractRulesEngine;
import org.jeasy.rules.core.RulesEngineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRulesEngine
extends AbstractRulesEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRulesEngine.class);

    public DefaultRulesEngine() {
    }

    public DefaultRulesEngine(RulesEngineParameters parameters) {
        super(parameters);
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    void doFire(Rules rules, Facts facts) {
        if (rules.isEmpty()) {
            LOGGER.warn("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.log(rules);
        this.log(facts);
        LOGGER.debug("Rules evaluation started");
        for (Rule rule : rules) {
            String name = rule.getName();
            int priority = rule.getPriority();
            if (priority > this.parameters.getPriorityThreshold()) {
                LOGGER.debug("Rule priority threshold ({}) exceeded at rule '{}' with priority={}, next rules will be skipped", new Object[]{this.parameters.getPriorityThreshold(), name, priority});
                break;
            }
            if (!this.shouldBeEvaluated(rule, facts)) {
                LOGGER.debug("Rule '{}' has been skipped before being evaluated", (Object)name);
                continue;
            }
            if (rule.evaluate(facts)) {
                LOGGER.debug("Rule '{}' triggered", (Object)name);
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    LOGGER.debug("Rule '{}' performed successfully", (Object)name);
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    LOGGER.error("Rule '" + name + "' performed with error", (Throwable)exception);
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            LOGGER.debug("Rule '{}' has been evaluated to false, it has not been executed", (Object)name);
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.debug("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    private void logEngineParameters() {
        LOGGER.debug(this.parameters.toString());
    }

    private void log(Rules rules) {
        LOGGER.debug("Registered rules:");
        for (Rule rule : rules) {
            LOGGER.debug("Rule { name = '{}', description = '{}', priority = '{}'}", new Object[]{rule.getName(), rule.getDescription(), rule.getPriority()});
        }
    }

    private void log(Facts facts) {
        LOGGER.debug("Known facts:");
        for (Map.Entry<String, Object> fact : facts) {
            LOGGER.debug("Fact { {} : {} }", (Object)fact.getKey(), fact.getValue());
        }
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> result = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return result;
    }

    private Map<Rule, Boolean> doCheck(Rules rules, Facts facts) {
        LOGGER.debug("Checking rules");
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            result.put(rule, rule.evaluate(facts));
        }
        return result;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onFailure(rule, facts, exception);
        }
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onSuccess(rule, facts);
        }
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.beforeExecute(rule, facts);
        }
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            if (ruleListener.beforeEvaluate(rule, facts)) continue;
            return false;
        }
        return true;
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.afterEvaluate(rule, facts, evaluationResult);
        }
    }

    private void triggerListenersBeforeRules(Rules rule, Facts facts) {
        for (RulesEngineListener rulesEngineListener : this.rulesEngineListeners) {
            rulesEngineListener.beforeEvaluate(rule, facts);
        }
    }

    private void triggerListenersAfterRules(Rules rule, Facts facts) {
        for (RulesEngineListener rulesEngineListener : this.rulesEngineListeners) {
            rulesEngineListener.afterExecute(rule, facts);
        }
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }
}

