/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.annotation_indexer;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubtypeIterator<T, U extends T>
implements Iterator<U> {
    private final Iterator<? extends T> core;
    private final Class<U> type;
    private T next;
    private boolean fetched;

    SubtypeIterator(Iterator<? extends T> core, Class<U> type) {
        this.core = core;
        this.type = type;
    }

    private void fetch() {
        while (!this.fetched && this.core.hasNext()) {
            T n = this.core.next();
            if (!this.type.isInstance(n)) continue;
            this.next = n;
            this.fetched = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.fetched;
    }

    @Override
    public U next() {
        this.fetch();
        if (!this.fetched) {
            throw new NoSuchElementException();
        }
        this.fetched = false;
        return this.type.cast(this.next);
    }

    @Override
    public void remove() {
        this.core.remove();
    }
}

