/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.security.bouncycastle;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.Decryptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import io.jenkins.cli.shaded.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import io.jenkins.cli.shaded.org.bouncycastle.pkcs.PKCSException;
import io.jenkins.cli.shaded.org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;

public enum BouncyCastleEncryptedPrivateKeyInfoDecryptor implements Decryptor
{
    INSTANCE;


    @Override
    public byte[] decrypt(byte[] encrypted, char[] password) throws GeneralSecurityException {
        SecurityProviderRegistrar registrar = SecurityUtils.getRegisteredProvider("BC");
        if (registrar == null) {
            throw new NoSuchProviderException("BC registrar not available");
        }
        try {
            JcePKCSPBEInputDecryptorProviderBuilder builder = new JcePKCSPBEInputDecryptorProviderBuilder();
            if (registrar.isNamedProviderUsed()) {
                builder.setProvider(registrar.getName());
            } else {
                builder.setProvider(registrar.getSecurityProvider());
            }
            PKCS8EncryptedPrivateKeyInfo info = new PKCS8EncryptedPrivateKeyInfo(encrypted);
            return info.decryptPrivateKeyInfo(builder.build(password)).getEncoded("DER");
        }
        catch (PKCSException | IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

