/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.jakarta.websocket.CloseReason;
import io.jenkins.cli.shaded.jakarta.websocket.Decoder;
import io.jenkins.cli.shaded.jakarta.websocket.DeploymentException;
import io.jenkins.cli.shaded.jakarta.websocket.Encoder;
import io.jenkins.cli.shaded.jakarta.websocket.EndpointConfig;
import io.jenkins.cli.shaded.jakarta.websocket.MessageHandler;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.AnnotatedEndpoint;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.ErrorCollector;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.MessageHandlerManager;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.PrimitivesToWrappers;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.l10n.LocalizationMessages;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class AnnotatedClassValidityChecker {
    private final Class<?> annotatedClass;
    private final List<Class<? extends Encoder>> encoders;
    private final ErrorCollector collector;
    private final MessageHandlerManager handlerManager;

    public AnnotatedClassValidityChecker(Class<?> annotatedClass, List<Class<? extends Encoder>> encoders, List<Class<? extends Decoder>> decoders, ErrorCollector collector) {
        this.annotatedClass = annotatedClass;
        this.encoders = encoders;
        this.collector = collector;
        this.handlerManager = new MessageHandlerManager(decoders);
    }

    public void checkOnMessageParams(Method method, MessageHandler handler) {
        try {
            this.handlerManager.addMessageHandler(handler);
        }
        catch (IllegalStateException ise) {
            this.collector.addException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_ADD_MESSAGE_HANDLER_ERROR(this.annotatedClass.getCanonicalName(), ise.getMessage()), ise.getCause()));
        }
        this.checkOnMessageReturnType(method);
    }

    private void checkOnMessageReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && returnType != String.class && returnType != ByteBuffer.class && returnType != byte[].class && !returnType.isPrimitive() && this.checkEncoders(returnType) && !PrimitivesToWrappers.isPrimitiveWrapper(returnType)) {
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_RETURN_TYPE(this.annotatedClass.getName(), method.getName())));
        }
    }

    public void checkOnOpenParams(Method method, Map<Integer, Class<?>> params) {
        for (Class<?> value : params.values()) {
            if (value == EndpointConfig.class) continue;
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_WEB_SOCKET_OPEN_PARAM(this.annotatedClass.getName(), method.getName(), value)));
        }
    }

    public void checkOnCloseParams(Method method, Map<Integer, Class<?>> params) {
        for (Class<?> value : params.values()) {
            if (value == CloseReason.class) continue;
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_WEB_SOCKET_CLOSE_PARAM(this.annotatedClass.getName(), method.getName())));
        }
    }

    public void checkOnErrorParams(Method method, Map<Integer, Class<?>> params) {
        boolean throwablePresent = false;
        for (Class<?> value : params.values()) {
            if (value != Throwable.class) {
                this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_WEB_SOCKET_ERROR_PARAM(this.annotatedClass.getName(), method.getName(), value)));
                continue;
            }
            if (throwablePresent) {
                this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_MULTIPLE_IDENTICAL_PARAMS(this.annotatedClass.getName(), method.getName())));
            }
            throwablePresent = true;
        }
        if (!throwablePresent) {
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_MANDATORY_PARAM_MISSING(this.annotatedClass.getName(), method.getName())));
        }
    }

    private String getPrefix(String methodName) {
        return String.format("Method:  %s.%s:", this.annotatedClass.getName(), methodName);
    }

    private boolean checkEncoders(Class<?> requiredType) {
        for (Class<? extends Encoder> encoderClass : this.encoders) {
            if (!AnnotatedEndpoint.getEncoderClassType(encoderClass).isAssignableFrom(requiredType)) continue;
            return false;
        }
        return true;
    }

    private void logDeploymentException(DeploymentException de) {
        this.collector.addException(de);
    }
}

