/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowImpl;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.util.UrlUtils;

public class TopLevelWindow
extends WebWindowImpl {
    private static final Log LOG = LogFactory.getLog(TopLevelWindow.class);
    private WebWindow opener_;

    protected TopLevelWindow(String name, WebClient webClient) {
        super(webClient);
        WebAssert.notNull("name", name);
        this.setName(name);
        this.performRegistration();
    }

    @Override
    public WebWindow getParentWindow() {
        return this;
    }

    @Override
    public WebWindow getTopWindow() {
        return this;
    }

    @Override
    protected boolean isJavaScriptInitializationNeeded(Page page) {
        return this.getScriptableObject() == null || page.getUrl() == UrlUtils.URL_ABOUT_BLANK || !(page.getWebResponse() instanceof StringWebResponse);
    }

    public String toString() {
        return "TopLevelWindow[name=\"" + this.getName() + "\"]";
    }

    public void setOpener(WebWindow opener) {
        this.opener_ = opener;
    }

    public WebWindow getOpener() {
        return this.opener_;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean ignoreOnbeforeunloadAccepted) {
        Page page = this.getEnclosedPage();
        if (page != null && page.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)page;
            boolean accepted = htmlPage.isOnbeforeunloadAccepted();
            if (!ignoreOnbeforeunloadAccepted && !accepted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The registered OnbeforeunloadHandler rejected the window close event.");
                }
                return;
            }
        }
        this.setClosed();
        if (page != null) {
            page.cleanUp();
        }
        this.getJobManager().shutdown();
        this.destroyChildren();
        this.getWebClient().deregisterWebWindow(this);
    }
}

