/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.activex.javascript.msxml;

import org.htmlunit.activex.javascript.msxml.XMLDOMNode;
import org.htmlunit.activex.javascript.msxml.XMLDOMNodeList;
import org.htmlunit.activex.javascript.msxml.XMLDOMText;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomText;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.util.StringUtils;

@JsxClass(domClass=DomAttr.class, value={SupportedBrowser.IE})
public class XMLDOMAttribute
extends XMLDOMNode {
    private XMLDOMText textNode_;

    @Override
    public XMLDOMNodeList getChildNodes() {
        this.initTextNode();
        return super.getChildNodes();
    }

    @Override
    public XMLDOMNode getFirstChild() {
        return this.getLastChild();
    }

    @Override
    public XMLDOMNode getLastChild() {
        this.initTextNode();
        return this.textNode_;
    }

    private void initTextNode() {
        String value;
        if (this.textNode_ == null && !hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(value = this.getValue())) {
            DomText text = new DomText(this.getDomNodeOrDie().getPage(), value);
            this.getDomNodeOrDie().appendChild(text);
            this.textNode_ = (XMLDOMText)text.getScriptableObject();
        }
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getName();
    }

    @JsxSetter
    public void setName(Object ignored) {
        throw ScriptRuntime.typeError("Wrong number of arguments or invalid property assignment");
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String value) {
        this.setValue(value);
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @JsxGetter
    public boolean isSpecified() {
        return this.getDomNodeOrDie().getSpecified();
    }

    @Override
    public Object getText() {
        return this.getValue();
    }

    @Override
    public void setText(Object value) {
        this.setValue(value == null ? null : Context.toString(value));
    }

    @JsxGetter
    public String getValue() {
        return this.getDomNodeOrDie().getValue();
    }

    @JsxSetter
    public void setValue(String value) {
        this.getDomNodeOrDie().setValue(value);
        this.resetTextNode();
    }

    private void resetTextNode() {
        if (this.textNode_ != null) {
            this.getDomNodeOrDie().removeChild(this.textNode_.getDomNodeOrNull());
            this.textNode_ = null;
        }
    }

    @Override
    public String getXml() {
        StringBuilder sb = new StringBuilder(this.getName()).append("=\"").append(StringUtils.escapeXmlAttributeValue(this.getValue())).append('\"');
        return sb.toString();
    }

    public void detachFromParent() {
        DomAttr domNode = this.getDomNodeOrDie();
        DomElement parent = (DomElement)domNode.getParentNode();
        if (parent != null) {
            domNode.setValue(parent.getAttribute(this.getName()));
        }
        domNode.remove();
    }

    @Override
    public DomAttr getDomNodeOrDie() {
        return (DomAttr)super.getDomNodeOrDie();
    }
}

