/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;

public final class HTMLNamedEntitiesParser {
    private static final HTMLNamedEntitiesParser instance = new HTMLNamedEntitiesParser();
    private RootState rootLevel = new RootState();

    private HTMLNamedEntitiesParser() {
        try (InputStream stream = HTMLNamedEntitiesParser.class.getResourceAsStream("html_entities.properties");){
            Properties props = new Properties();
            props.load(stream);
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                String value = (String)v;
                if (key.trim().isEmpty()) {
                    return;
                }
                this.rootLevel.add(key, value);
            }));
            this.rootLevel.optimize();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initilaize the HTML entities from file");
        }
    }

    public static HTMLNamedEntitiesParser get() {
        return instance;
    }

    public State lookup(String entityName) {
        State lastResult = this.rootLevel;
        State lastMatchingResult = null;
        for (int i = 0; i < entityName.length(); ++i) {
            State result = ((State)lastResult).lookup(entityName.charAt(i));
            if (result.endNode) {
                return result;
            }
            if (result == lastResult) {
                return lastMatchingResult == null ? lastResult : lastMatchingResult;
            }
            if (result.isMatch) {
                lastMatchingResult = result;
            }
            lastResult = result;
        }
        return lastMatchingResult == null ? lastResult : lastMatchingResult;
    }

    public State lookup(int character, State state) {
        return state != null ? state.lookup(character) : this.rootLevel.lookup(character);
    }

    protected static class RootState
    extends State {
        private int offset = 0;

        protected RootState() {
        }

        @Override
        public State lookup(int character) {
            int pos = character - this.offset;
            if (pos >= 0 && pos < this.nextState.length) {
                State s = this.nextState[pos];
                return s != null ? s : this;
            }
            return this;
        }

        protected void optimize() {
            if (this.offset > 0) {
                throw new RuntimeException("Optimiize was called twice");
            }
            this.offset = this.characters[0];
            State[] newNextLevel = new State[this.characters[this.characters.length - 1] - this.offset + 1];
            for (int i = 0; i < this.characters.length; ++i) {
                State level;
                int c = this.characters[i];
                newNextLevel[c - this.offset] = level = this.nextState[i];
            }
            this.nextState = newNextLevel;
            this.characters = null;
        }
    }

    public static class State {
        private final int depth;
        int[] characters = new int[0];
        State[] nextState = new State[0];
        public final String entityOrFragment;
        public String resolvedValue;
        public final int length;
        public final boolean endsWithSemicolon;
        public boolean isMatch;
        public boolean endNode;

        protected State() {
            this.entityOrFragment = "";
            this.length = 0;
            this.depth = 0;
            this.endsWithSemicolon = false;
            this.isMatch = false;
            this.resolvedValue = null;
            this.endNode = false;
        }

        protected State(int depth, String entityFragment, String resolvedValue) {
            if (depth == entityFragment.length()) {
                this.entityOrFragment = entityFragment;
                this.length = entityFragment.length();
                this.depth = entityFragment.length();
                this.endsWithSemicolon = entityFragment.endsWith(";");
                this.isMatch = true;
                this.resolvedValue = resolvedValue;
                this.endNode = entityFragment.endsWith(";");
            } else {
                String currentFragment;
                this.entityOrFragment = currentFragment = entityFragment.substring(0, depth);
                this.length = currentFragment.length();
                this.depth = depth;
                this.endsWithSemicolon = false;
                this.isMatch = false;
                this.resolvedValue = null;
                this.endNode = false;
            }
        }

        protected void updateNonSemicolonEntity(String entity, String resolvedValue) {
            if (entity.endsWith(";")) {
                return;
            }
            if (entity.length() == this.depth) {
                if (!entity.equals(this.entityOrFragment)) {
                    throw new RuntimeException("Illegal state reached");
                }
                this.endNode = false;
                this.isMatch = true;
                this.resolvedValue = resolvedValue;
            }
        }

        protected void add(String entity, String resolvedValue) {
            if (this.depth >= entity.length()) {
                return;
            }
            char c = entity.charAt(this.depth);
            int pos = Arrays.binarySearch(this.characters, (int)c);
            if (pos < 0) {
                this.nextState = Arrays.copyOf(this.nextState, this.nextState.length + 1);
                this.characters = Arrays.copyOf(this.characters, this.characters.length + 1);
                int newPos = -(pos + 1);
                if (newPos != this.characters.length - 1) {
                    System.arraycopy(this.characters, newPos, this.characters, newPos + 1, this.characters.length - newPos - 1);
                    System.arraycopy(this.nextState, newPos, this.nextState, newPos + 1, this.nextState.length - newPos - 1);
                }
                State newLevel = new State(this.depth + 1, entity, resolvedValue);
                this.characters[newPos] = c;
                this.nextState[newPos] = newLevel;
                newLevel.add(entity, resolvedValue);
            } else {
                this.nextState[pos].updateNonSemicolonEntity(entity, resolvedValue);
                this.nextState[pos].add(entity, resolvedValue);
            }
        }

        protected State lookup(int character) {
            int length = this.characters.length;
            for (int i = 0; i < length; ++i) {
                int c = this.characters[i];
                if (c < character) continue;
                if (c == character) {
                    return this.nextState[i];
                }
                return this;
            }
            return this;
        }
    }
}

