/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlSelectableTextInput;
import org.htmlunit.html.LabelableElement;

public class HtmlNumberInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final char[] VALID_INT_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'};
    private static final String VALID_CHARS = "0123456789-+.eE";

    HtmlNumberInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (!value.isEmpty() && !StringUtils.containsOnly((CharSequence)value, VALID_CHARS)) {
            this.setRawValue("");
        }
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    protected void doType(char c, boolean lastType) {
        if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL) && VALID_CHARS.indexOf(c) == -1) {
            return;
        }
        super.doType(c, lastType);
    }

    @Override
    public String getValue() {
        String raw = this.getRawValue();
        if (StringUtils.isBlank(raw)) {
            return "";
        }
        if ("-".equals(raw) || "+".equals(raw)) {
            return raw;
        }
        try {
            String lang = ((SgmlPage)this.getPage()).getWebClient().getBrowserVersion().getBrowserLanguage();
            NumberFormat format = NumberFormat.getInstance(Locale.forLanguageTag(lang));
            format.parse(raw);
            return raw.trim();
        }
        catch (ParseException parseException) {
            if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL)) {
                return raw;
            }
            return "";
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String rawValue = this.getRawValue();
        if (StringUtils.isBlank(rawValue)) {
            return true;
        }
        if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL)) {
            rawValue = rawValue.replaceAll("\\s", "");
        }
        if (!rawValue.isEmpty()) {
            BigDecimal value;
            block22: {
                if ("-".equals(rawValue) || "+".equals(rawValue)) {
                    return false;
                }
                if (this.getStep().isEmpty()) {
                    String val = rawValue;
                    int lastPos = val.length() - 1;
                    if (lastPos >= 0 && val.charAt(lastPos) == '.') {
                        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                            return false;
                        }
                        val = val.substring(0, lastPos);
                    }
                    if (!StringUtils.containsOnly((CharSequence)val, VALID_INT_CHARS)) {
                        return false;
                    }
                }
                try {
                    value = new BigDecimal(rawValue);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (!this.getMin().isEmpty()) {
                    try {
                        BigDecimal min = new BigDecimal(this.getMin());
                        if (value.compareTo(min) < 0) {
                            return false;
                        }
                        if (this.getStep().isEmpty()) break block22;
                        try {
                            BigDecimal step = new BigDecimal(this.getStep());
                            if (value.subtract(min).abs().remainder(step).doubleValue() > 0.0) {
                                return false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    catch (NumberFormatException min) {
                        // empty catch block
                    }
                }
            }
            if (!this.getMax().isEmpty()) {
                try {
                    BigDecimal max = new BigDecimal(this.getMax());
                    if (value.compareTo(max) > 0) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return true;
    }
}

