/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlSelectableTextInput;
import org.htmlunit.html.LabelableElement;

public class HtmlTimeInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final DateTimeFormatter INPUT_FORMATTER_ = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("hh[:]mm[a]").parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.AMPM_OF_DAY, 0L).toFormatter(Locale.US);
    private static final DateTimeFormatter OUTPUT_FORMATTER_ = DateTimeFormatter.ofPattern("HH:mm");

    HtmlTimeInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public String getValue() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED)) {
            String raw = this.getRawValue();
            if (StringUtils.isBlank(raw)) {
                return "";
            }
            raw = raw.trim();
            try {
                TemporalAccessor time = INPUT_FORMATTER_.parse(raw);
                return OUTPUT_FORMATTER_.format(time);
            }
            catch (DateTimeParseException dateTimeParseException) {
                return "";
            }
        }
        return this.getRawValue();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                LocalTime timeValue = LocalTime.parse(this.getRawValue(), INPUT_FORMATTER_);
                LocalTime minTime = LocalTime.parse(this.getMin(), INPUT_FORMATTER_);
                return minTime.equals(timeValue) || minTime.isBefore(timeValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                LocalTime timeValue = LocalTime.parse(this.getRawValue(), INPUT_FORMATTER_);
                LocalTime maxTime = LocalTime.parse(this.getMax(), INPUT_FORMATTER_);
                return maxTime.equals(timeValue) || maxTime.isAfter(timeValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected void adjustValueAfterTypeChange(HtmlInput oldInput, BrowserVersion browserVersion) {
        this.setRawValue("");
    }
}

