/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import hidden.jth.org.apache.commons.lang3.time.FastDateFormat;
import java.util.Date;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.host.Window;

public final class DateCustom {
    private DateCustom() {
    }

    public static String toLocaleDateString(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        String formatString = browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK) ? "\u200eM\u200e/\u200ed\u200e/\u200eyyyy" : (browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_LOCALE_DATE_SHORT) ? "M/d/yyyy" : "EEEE, MMMM dd, yyyy");
        FastDateFormat format = FastDateFormat.getInstance(formatString, browserVersion.getBrowserLocale());
        return format.format(DateCustom.getDateValue(thisObj));
    }

    public static String toLocaleTimeString(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        String formatString = browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK) ? "\u200eh\u200e:\u200emm\u200e:\u200ess\u200e \u200ea" : "h:mm:ss a";
        FastDateFormat format = FastDateFormat.getInstance(formatString, browserVersion.getBrowserLocale());
        return format.format(DateCustom.getDateValue(thisObj));
    }

    private static long getDateValue(Scriptable thisObj) {
        Date date = (Date)Context.jsToJava(thisObj, Date.class);
        return date.getTime();
    }
}

