/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.host.html.HTMLCollection;

class HTMLCollectionFrames
extends HTMLCollection {
    private static final Log LOG = LogFactory.getLog(HTMLCollectionFrames.class);

    HTMLCollectionFrames(HtmlPage page) {
        super((DomNode)page, false);
        this.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> node instanceof BaseFrameElement);
    }

    @Override
    protected Scriptable getScriptableForElement(Object obj) {
        FrameWindow window = obj instanceof BaseFrameElement ? ((BaseFrameElement)obj).getEnclosedWindow() : ((FrameWindow)obj).getFrameElement().getEnclosedWindow();
        return (Scriptable)window.getScriptableObject();
    }

    @Override
    protected Object getWithPreemption(String name) {
        List<DomNode> elements = this.getElements();
        for (DomNode next : elements) {
            BaseFrameElement frameElt = (BaseFrameElement)next;
            FrameWindow window = frameElt.getEnclosedWindow();
            if (name.equals(window.getName())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Property \"" + name + "\" evaluated (by name) to " + window));
                }
                return this.getScriptableForElement(window);
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FRAMES_ACCESSIBLE_BY_ID) || !frameElt.getId().equals(name)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property \"" + name + "\" evaluated (by id) to " + window));
            }
            return this.getScriptableForElement(window);
        }
        return NOT_FOUND;
    }
}

