/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.htmlunit.corejs.javascript.ExternalArrayData;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomChangeEvent;
import org.htmlunit.html.DomChangeListener;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlAttributeChangeListener;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;

@JsxClass(isJSObject=false)
public class AbstractList
extends HtmlUnitScriptable
implements ExternalArrayData {
    private boolean avoidObjectDetection_;
    private boolean attributeChangeSensitive_;
    private List<DomNode> cachedElements_;
    private boolean listenerRegistered_;
    private Function<HtmlAttributeChangeEvent, EffectOnCache> effectOnCacheFunction_ = (Function<HtmlAttributeChangeEvent, EffectOnCache> & Serializable)event -> EffectOnCache.RESET;
    private Predicate<DomNode> isMatchingPredicate_ = (Predicate<DomNode> & Serializable)domNode -> false;
    private Supplier<List<DomNode>> elementsSupplier_ = (Supplier<List> & Serializable)() -> {
        ArrayList<DomNode> response = new ArrayList<DomNode>();
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode desc : domNode.getDescendants()) {
            if (!(desc instanceof DomElement) || !this.isMatchingPredicate_.test(desc)) continue;
            response.add(desc);
        }
        return response;
    };

    public AbstractList() {
    }

    protected AbstractList(DomNode domNode2, boolean attributeChangeSensitive, List<DomNode> initialElements) {
        if (domNode2 != null) {
            this.setDomNode(domNode2, false);
            ScriptableObject parentScope = (ScriptableObject)domNode2.getScriptableObject();
            if (parentScope != null) {
                this.setParentScope(parentScope);
                this.setPrototype(this.getPrototype(this.getClass()));
            }
        }
        this.attributeChangeSensitive_ = attributeChangeSensitive;
        this.cachedElements_ = initialElements;
        if (initialElements != null) {
            this.registerListener();
        }
        this.setExternalArrayData(this);
    }

    @Override
    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public void setEffectOnCacheFunction(Function<HtmlAttributeChangeEvent, EffectOnCache> effectOnCacheFunction) {
        if (effectOnCacheFunction == null) {
            throw new NullPointerException("EffectOnCacheFunction can't be null");
        }
        this.effectOnCacheFunction_ = effectOnCacheFunction;
    }

    protected Supplier<List<DomNode>> getElementSupplier() {
        return this.elementsSupplier_;
    }

    public void setElementsSupplier(Supplier<List<DomNode>> elementsSupplier) {
        if (elementsSupplier == null) {
            throw new NullPointerException("ElementsSupplier can't be null");
        }
        this.elementsSupplier_ = elementsSupplier;
    }

    protected Predicate<DomNode> getIsMatchingPredicate() {
        return this.isMatchingPredicate_;
    }

    public void setIsMatchingPredicate(Predicate<DomNode> isMatchingPredicate) {
        if (isMatchingPredicate == null) {
            throw new NullPointerException("IsMatchingPredicate can't be null");
        }
        this.isMatchingPredicate_ = isMatchingPredicate;
    }

    protected Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    @Override
    public void setDomNode(DomNode domNode, boolean assignScriptObject) {
        DomNode oldDomNode = this.getDomNodeOrNull();
        super.setDomNode(domNode, assignScriptObject);
        if (oldDomNode != domNode) {
            this.listenerRegistered_ = false;
        }
    }

    public List<DomNode> getElements() {
        List<DomNode> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            cachedElements = this.getParentScope() == null ? new ArrayList<DomNode>() : this.elementsSupplier_.get();
            this.cachedElements_ = cachedElements;
        }
        this.registerListener();
        return cachedElements;
    }

    private void registerListener() {
        DomNode domNode;
        if (!this.listenerRegistered_ && (domNode = this.getDomNodeOrNull()) != null) {
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
            domNode.addDomChangeListener(listener);
            if (this.attributeChangeSensitive_) {
                if (domNode instanceof HtmlElement) {
                    ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                } else if (domNode instanceof HtmlPage) {
                    ((HtmlPage)domNode).addHtmlAttributeChangeListener(listener);
                }
            }
            this.listenerRegistered_ = true;
        }
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<DomNode> elements = this.getElements();
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        for (DomNode next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getId())) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            AbstractList collection = this.create(this.getDomNodeOrDie(), matchingElements);
            collection.setAvoidObjectDetection(true);
            return collection;
        }
        return this.getWithPreemptionByName(name, elements);
    }

    protected AbstractList create(DomNode parentScope, List<DomNode> initialElements) {
        throw new IllegalAccessError("Creation of AbstractListInstances is not allowed.");
    }

    protected Object getWithPreemptionByName(String name, List<DomNode> elements) {
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        AbstractList collection = this.create(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    public int getLength() {
        return this.getElements().size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.getDomNodeOrNull();
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof AbstractList) {
            AbstractList otherArray = (AbstractList)other;
            DomNode domNode = this.getDomNodeOrNull();
            DomNode domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && this.getElements().equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    @Override
    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) {
        if ("length".equals(propertyName) && this.getPrototype() != null) {
            return;
        }
        super.defineProperty(propertyName, delegateTo, getter, setter, attributes);
    }

    @Override
    public Object getArrayElement(int index) {
        List<DomNode> elements = this.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    @Override
    public void setArrayElement(int index, Object value) {
    }

    @Override
    public int getArrayLength() {
        return this.getElements().size();
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private final transient WeakReference<AbstractList> nodeList_;

        DomHtmlAttributeChangeListenerImpl(AbstractList nodeList) {
            this.nodeList_ = new WeakReference<AbstractList>(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            if (nodes.attributeChangeSensitive_) {
                this.handleChangeOnCache(event);
            }
        }

        private void handleChangeOnCache(HtmlAttributeChangeEvent event) {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            EffectOnCache effectOnCache = (EffectOnCache)((Object)nodes.effectOnCacheFunction_.apply(event));
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                this.clearCache();
            }
        }

        private void clearCache() {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }

    public static enum EffectOnCache {
        NONE,
        RESET;

    }
}

