/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.impl.SimpleRange;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.Range;

@JsxClass
public class Selection
extends HtmlUnitScriptable {
    private static final String TYPE_NONE = "None";
    private static final String TYPE_CARET = "Caret";
    private static final String TYPE_RANGE = "Range";
    private String type_ = "None";

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Selection() {
    }

    @JsxFunction(functionName="toString")
    public String jsToString() {
        StringBuilder sb = new StringBuilder();
        for (SimpleRange r : this.getRanges()) {
            sb.append(r.toString());
        }
        return sb.toString();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null && (String.class.equals(hint) || hint == null)) {
            return this.jsToString();
        }
        return super.getDefaultValue(hint);
    }

    @JsxGetter
    public Node getAnchorNode() {
        SimpleRange last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getStartContainer());
    }

    @JsxGetter
    public int getAnchorOffset() {
        SimpleRange last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getStartOffset();
    }

    @JsxGetter
    public Node getFocusNode() {
        SimpleRange last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getEndContainer());
    }

    @JsxGetter
    public int getFocusOffset() {
        SimpleRange last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getEndOffset();
    }

    @JsxGetter
    public boolean isIsCollapsed() {
        List<SimpleRange> ranges = this.getRanges();
        return ranges.isEmpty() || ranges.size() == 1 && ranges.get(0).isCollapsed();
    }

    @JsxGetter
    public int getRangeCount() {
        return this.getRanges().size();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getType() {
        return this.type_;
    }

    @JsxFunction
    public void addRange(Range range) {
        SimpleRange rg = range.getSimpleRange();
        this.getRanges().add(rg);
        if (TYPE_CARET.equals(this.type_) && rg.isCollapsed()) {
            return;
        }
        this.type_ = TYPE_RANGE;
    }

    @JsxFunction
    public void removeRange(Range range) {
        this.getRanges().remove(range.getSimpleRange());
        if (this.getRangeCount() < 1) {
            this.type_ = TYPE_NONE;
        }
    }

    @JsxFunction
    public void removeAllRanges() {
        this.getRanges().clear();
        this.type_ = TYPE_NONE;
    }

    @JsxFunction
    public Range getRangeAt(int index) {
        List<SimpleRange> ranges = this.getRanges();
        if (index < 0 || index >= ranges.size()) {
            throw Context.reportRuntimeError("Invalid range index: " + index);
        }
        SimpleRange range = ranges.get(index);
        Range jsRange = new Range(range);
        jsRange.setParentScope(this.getWindow());
        jsRange.setPrototype(this.getPrototype(Range.class));
        return jsRange;
    }

    @JsxFunction
    public void collapse(Node parentNode, int offset) {
        List<SimpleRange> ranges = this.getRanges();
        ranges.clear();
        ranges.add(new SimpleRange(parentNode.getDomNodeOrDie(), offset));
        this.type_ = TYPE_CARET;
    }

    @JsxFunction
    public void collapseToEnd() {
        SimpleRange last = this.getLastRange();
        if (last != null) {
            List<SimpleRange> ranges = this.getRanges();
            ranges.clear();
            ranges.add(last);
            last.collapse(false);
        }
        this.type_ = TYPE_CARET;
    }

    @JsxFunction
    public void collapseToStart() {
        SimpleRange first = this.getFirstRange();
        if (first != null) {
            List<SimpleRange> ranges = this.getRanges();
            ranges.clear();
            ranges.add(first);
            first.collapse(true);
        }
        this.type_ = TYPE_CARET;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void empty() {
        this.removeAllRanges();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void extend(Node parentNode, int offset) {
        SimpleRange last = this.getLastRange();
        if (last != null) {
            last.setEnd(parentNode.getDomNodeOrDie(), offset);
            this.type_ = TYPE_RANGE;
        }
    }

    @JsxFunction
    public void selectAllChildren(Node parentNode) {
        List<SimpleRange> ranges = this.getRanges();
        ranges.clear();
        SimpleRange simpleRange = new SimpleRange(parentNode.getDomNodeOrDie());
        ranges.add(simpleRange);
        this.type_ = simpleRange.isCollapsed() ? TYPE_CARET : TYPE_RANGE;
    }

    private List<SimpleRange> getRanges() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        return page.getSelectionRanges();
    }

    private SimpleRange getFirstRange() {
        ArrayList<SimpleRange> ranges = new ArrayList<SimpleRange>(this.getRanges());
        SimpleRange first = null;
        for (SimpleRange range : ranges) {
            DomNode rangeStart;
            if (first == null) {
                first = range;
                continue;
            }
            DomNode firstStart = first.getStartContainer();
            if ((firstStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 2) == 0) continue;
            first = range;
        }
        return first;
    }

    private SimpleRange getLastRange() {
        ArrayList<SimpleRange> ranges = new ArrayList<SimpleRange>(this.getRanges());
        SimpleRange last = null;
        for (SimpleRange range : ranges) {
            DomNode rangeStart;
            if (last == null) {
                last = range;
                continue;
            }
            DomNode lastStart = last.getStartContainer();
            if ((lastStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 4) == 0) continue;
            last = range;
        }
        return last;
    }

    private HtmlUnitScriptable getScriptableNullSafe(Object object) {
        HtmlUnitScriptable scriptable = object != null ? this.getScriptableFor(object) : null;
        return scriptable;
    }
}

