/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.event;

import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.event.Event;

@JsxClass
public class BeforeUnloadEvent
extends Event {
    private Object returnValue_;

    public BeforeUnloadEvent() {
        this.setType("");
        this.returnValue_ = "";
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        Context.throwAsScriptRuntimeEx(new IllegalArgumentException("Illegal Constructor"));
    }

    public BeforeUnloadEvent(DomNode domNode, String type) {
        super(domNode, type);
        this.setBubbles(false);
        this.setReturnValue(BeforeUnloadEvent.getReturnValueDefault(this.getBrowserVersion()));
    }

    @Override
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        super.initEvent(type, bubbles, cancelable);
        this.setReturnValue(BeforeUnloadEvent.getReturnValueDefault(this.getBrowserVersion()));
    }

    private static Object getReturnValueDefault(BrowserVersion browserVersion) {
        if (browserVersion.hasFeature(BrowserVersionFeatures.EVENT_BEFORE_UNLOAD_RETURN_VALUE_IS_HTML5_LIKE)) {
            return "";
        }
        return Undefined.instance;
    }

    public boolean isBeforeUnloadMessageSet() {
        return !BeforeUnloadEvent.getReturnValueDefault(this.getBrowserVersion()).equals(this.getReturnValue());
    }

    @Override
    @JsxGetter
    public Object getReturnValue() {
        return this.returnValue_;
    }

    @Override
    @JsxSetter
    public void setReturnValue(Object returnValue) {
        this.returnValue_ = returnValue;
    }

    @Override
    void handlePropertyHandlerReturnValue(Object returnValue) {
        super.handlePropertyHandlerReturnValue(returnValue);
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (!(returnValue == null && !browserVersion.hasFeature(BrowserVersionFeatures.EVENT_HANDLER_NULL_RETURN_IS_MEANINGFUL) || browserVersion.hasFeature(BrowserVersionFeatures.EVENT_BEFORE_UNLOAD_RETURN_VALUE_IS_HTML5_LIKE) && !BeforeUnloadEvent.getReturnValueDefault(browserVersion).equals(this.getReturnValue()))) {
            this.setReturnValue(returnValue);
        }
    }
}

