/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.event;

import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomNode;

public class EventHandler
extends BaseFunction {
    private final DomNode node_;
    private final String eventName_;
    private final String jsSnippet_;
    private Function realFunction_;

    public EventHandler(DomNode node, String eventName, String jsSnippet) {
        this.node_ = node;
        this.eventName_ = eventName;
        this.jsSnippet_ = jsSnippet;
        this.setPrototype(ScriptableObject.getClassPrototype((Scriptable)node.getScriptableObject(), "Function"));
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.realFunction_ == null) {
            String js = "function on" + this.eventName_ + "(event) { " + this.jsSnippet_ + " \n}";
            this.realFunction_ = cx.compileFunction(thisObj, js, this.eventName_ + " event for " + this.node_ + " in " + this.node_.getPage().getUrl(), 0, null);
            this.realFunction_.setParentScope(thisObj);
        }
        return this.realFunction_.call(cx, scope, thisObj, args);
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return "function on" + this.eventName_ + "(event) { " + this.jsSnippet_ + " }";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("toString".equals(name)) {
            return new BaseFunction(){

                @Override
                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    return "function on" + EventHandler.this.eventName_ + "(event) { " + EventHandler.this.jsSnippet_ + " }";
                }
            };
        }
        return super.get(name, start);
    }
}

