/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlAddress;
import org.htmlunit.html.HtmlBlockQuote;
import org.htmlunit.html.HtmlCenter;
import org.htmlunit.html.HtmlExample;
import org.htmlunit.html.HtmlListing;
import org.htmlunit.html.HtmlPlainText;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.ActiveXObject;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClasses(value={@JsxClass(domClass=HtmlAddress.class, value={SupportedBrowser.IE}), @JsxClass(domClass=HtmlBlockQuote.class, value={SupportedBrowser.IE}), @JsxClass(domClass=HtmlCenter.class, value={SupportedBrowser.IE}), @JsxClass(domClass=HtmlExample.class, value={SupportedBrowser.IE}), @JsxClass(domClass=HtmlListing.class, value={SupportedBrowser.IE}), @JsxClass(domClass=HtmlPlainText.class, value={SupportedBrowser.IE})})
public class HTMLBlockElement
extends HTMLElement {
    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SUPPORT_VIA_ACTIVEXOBJECT)) {
            ActiveXObject.addProperty((HtmlUnitScriptable)this, "cite", true, true);
        }
    }

    public String getCite() {
        return this.getDomNodeOrDie().getAttributeDirect("cite");
    }

    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    public String getDateTime() {
        return this.getDomNodeOrDie().getAttributeDirect("datetime");
    }

    public void setDateTime(String dateTime) {
        this.getDomNodeOrDie().setAttribute("datetime", dateTime);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLKEYGEN_END_TAG_FORBIDDEN) && "KEYGEN".equals(this.getNodeName());
    }

    @JsxGetter
    public String getClear() {
        return this.getDomNodeOrDie().getAttributeDirect("clear");
    }

    @JsxSetter
    public void setClear(String clear) {
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", Boolean.TRUE);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.setWidthOrHeight("width", width, true);
    }
}

