/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.FormEncodingType;
import org.htmlunit.WebAssert;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FormFieldWithNameHistory;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.html.HTMLButtonElement;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLInputElement;

@JsxClass(domClass=HtmlForm.class)
public class HTMLFormElement
extends HTMLElement
implements Function {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLFormElement() {
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getHtmlForm().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getHtmlForm().setNameAttribute(name);
    }

    @JsxGetter
    public HTMLCollection getElements() {
        HtmlForm htmlForm = this.getHtmlForm();
        HTMLCollection elements = new HTMLCollection(htmlForm, false){

            @Override
            protected Object getWithPreemption(String name) {
                return HTMLFormElement.this.getWithPreemption(name);
            }
        };
        elements.setElementsSupplier((Supplier<List> & Serializable)() -> {
            ArrayList<HtmlElement> response = new ArrayList<HtmlElement>();
            HtmlElement domNode = this.getDomNodeOrNull();
            if (domNode == null) {
                return new ArrayList();
            }
            response.addAll(((HtmlForm)domNode).getElements());
            return response;
        });
        elements.setEffectOnCacheFunction((java.util.function.Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> AbstractList.EffectOnCache.NONE);
        return elements;
    }

    @JsxSymbol(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator iterator() {
        return this.getElements().iterator();
    }

    @JsxGetter
    public int getLength() {
        int all = this.getElements().getLength();
        int images = this.getHtmlForm().getElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    @JsxGetter
    public String getAction() {
        String action = this.getHtmlForm().getActionAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED == action && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_ACTION_EXPANDURL_NOT_DEFINED)) {
            return action;
        }
        try {
            return ((HtmlPage)this.getHtmlForm().getPage()).getFullyQualifiedUrl(action).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return action;
        }
    }

    @JsxSetter
    public void setAction(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    @JsxGetter
    public String getMethod() {
        return this.getHtmlForm().getMethodAttribute();
    }

    @JsxSetter
    public void setMethod(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    @JsxGetter
    public String getTarget() {
        return this.getHtmlForm().getTargetAttribute();
    }

    @JsxSetter
    public void setTarget(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getRel() {
        return this.getHtmlForm().getRelAttribute();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setRel(String rel) {
        this.getHtmlForm().setAttribute("rel", rel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setRelList(Object rel) {
        if (Undefined.isUndefined(rel)) {
            this.setRel("undefined");
            return;
        }
        this.setRel(ScriptRuntime.toString(rel));
    }

    @JsxGetter
    public String getEnctype() {
        String encoding = this.getHtmlForm().getEnctypeAttribute();
        if (!(FormEncodingType.URL_ENCODED.getName().equals(encoding) || FormEncodingType.MULTIPART.getName().equals(encoding) || "text/plain".equals(encoding))) {
            return FormEncodingType.URL_ENCODED.getName();
        }
        return encoding;
    }

    @JsxSetter
    public void setEnctype(String enctype) {
        WebAssert.notNull("encoding", enctype);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_REJECT_INVALID_ENCODING) && !FormEncodingType.URL_ENCODED.getName().equals(enctype) && !FormEncodingType.MULTIPART.getName().equals(enctype) && !FormEncodingType.TEXT_PLAIN.getName().equals(enctype)) {
            throw Context.reportRuntimeError("Cannot set the encoding property to invalid value: '" + enctype + "'");
        }
        this.getHtmlForm().setEnctypeAttribute(enctype);
    }

    @JsxGetter
    public String getEncoding() {
        return this.getEnctype();
    }

    @JsxSetter
    public void setEncoding(String encoding) {
        this.setEnctype(encoding);
    }

    public HtmlForm getHtmlForm() {
        return (HtmlForm)this.getDomNodeOrDie();
    }

    @JsxFunction
    public void submit() {
        this.getHtmlForm().submit(null);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void requestSubmit(Object submitter) {
        if (Undefined.isUndefined(submitter)) {
            this.submit();
            return;
        }
        SubmittableElement submittable = null;
        if (submitter instanceof HTMLElement) {
            HTMLElement subHtmlElement = (HTMLElement)submitter;
            if (subHtmlElement instanceof HTMLButtonElement) {
                if ("submit".equals(((HTMLButtonElement)subHtmlElement).getType())) {
                    submittable = (SubmittableElement)((Object)subHtmlElement.getDomNodeOrDie());
                }
            } else if (subHtmlElement instanceof HTMLInputElement && "submit".equals(((HTMLInputElement)subHtmlElement).getType())) {
                submittable = (SubmittableElement)((Object)subHtmlElement.getDomNodeOrDie());
            }
            if (submittable != null && subHtmlElement.getForm() != this) {
                throw ScriptRuntime.typeError("Failed to execute 'requestSubmit' on 'HTMLFormElement': The specified element is not owned by this form element.");
            }
        }
        if (submittable == null) {
            throw ScriptRuntime.typeError("Failed to execute 'requestSubmit' on 'HTMLFormElement': The specified element is not a submit button.");
        }
        this.getHtmlForm().submit(submittable);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object item(Object index, Object subIndex) {
        if (index instanceof Number) {
            return this.getElements().item(index);
        }
        String name = Context.toString(index);
        Object response = this.getWithPreemption(name);
        if (subIndex instanceof Number && response instanceof HTMLCollection) {
            return ((HTMLCollection)response).item(subIndex);
        }
        return response;
    }

    @JsxFunction
    public void reset() {
        this.getHtmlForm().reset();
    }

    @Override
    protected Object getWithPreemption(String name) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        List<HtmlElement> elements = this.findElements(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        ArrayList<DomNode> nodes = new ArrayList<DomNode>(elements);
        HTMLCollection coll = new HTMLCollection((DomNode)this.getHtmlForm(), nodes);
        coll.setElementsSupplier((Supplier<List> & Serializable)() -> new ArrayList<HtmlElement>(this.findElements(name)));
        return coll;
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        return this.findFirstElement(name) != null;
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        HtmlElement element;
        ScriptableObject desc = super.getOwnPropertyDescriptor(cx, id);
        if (desc != null) {
            return desc;
        }
        if (id instanceof CharSequence && (element = this.findFirstElement(id.toString())) != null) {
            return ScriptableObject.buildDataDescriptor(this, element.getScriptableObject(), 3);
        }
        return null;
    }

    List<HtmlElement> findElements(String name) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        HtmlForm form = (HtmlForm)this.getDomNodeOrNull();
        if (form == null) {
            return elements;
        }
        for (HtmlElement htmlElement : form.getElements()) {
            if (!this.isAccessibleByIdOrName(htmlElement, name)) continue;
            elements.add(htmlElement);
        }
        if (elements.isEmpty()) {
            for (DomNode domNode : form.getHtmlElementDescendants()) {
                HtmlImage img;
                if (!(domNode instanceof HtmlImage) || !name.equals((img = (HtmlImage)domNode).getId()) && !name.equals(img.getNameAttribute())) continue;
                elements.add(img);
            }
        }
        return elements;
    }

    private HtmlElement findFirstElement(String name) {
        HtmlForm form = (HtmlForm)this.getDomNodeOrNull();
        if (form == null) {
            return null;
        }
        for (DomNode node : form.getElements()) {
            if (!this.isAccessibleByIdOrName((HtmlElement)node, name)) continue;
            return node;
        }
        for (DomNode node : form.getHtmlElementDescendants()) {
            HtmlImage img;
            if (!(node instanceof HtmlImage) || !name.equals((img = (HtmlImage)node).getId()) && !name.equals(img.getNameAttribute())) continue;
            return img;
        }
        return null;
    }

    private boolean isAccessibleByIdOrName(HtmlElement element, String name) {
        if (element instanceof FormFieldWithNameHistory && !(element instanceof HtmlImageInput)) {
            if (element.getEnclosingForm() != this.getHtmlForm()) {
                return false;
            }
            if (name.equals(element.getId())) {
                return true;
            }
            FormFieldWithNameHistory elementWithNames = (FormFieldWithNameHistory)((Object)element);
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORMFIELD_REACHABLE_BY_ORIGINAL_NAME) ? name.equals(elementWithNames.getOriginalName()) : name.equals(element.getAttributeDirect("name"))) {
                return true;
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORMFIELD_REACHABLE_BY_NEW_NAMES) && elementWithNames.getNewNames().contains(name)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.getElements().get(index, (Scriptable)((HTMLFormElement)start).getElements());
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_USABLE_AS_FUNCTION)) {
            throw Context.reportRuntimeError("Not a function.");
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof String) {
                return ScriptableObject.getProperty((Scriptable)this, (String)arg);
            }
            if (arg instanceof Number) {
                return ScriptableObject.getProperty((Scriptable)this, ((Number)arg).intValue());
            }
        }
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_USABLE_AS_FUNCTION)) {
            throw Context.reportRuntimeError("Not a function.");
        }
        return null;
    }

    @Override
    public boolean dispatchEvent(Event event) {
        boolean result = super.dispatchEvent(event);
        if ("submit".equals(event.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_DISPATCHEVENT_SUBMITS)) {
            this.submit();
        }
        return result;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @JsxGetter
    public boolean isNoValidate() {
        return this.getHtmlForm().isNoValidate();
    }

    @JsxSetter
    public void setNoValidate(boolean value) {
        this.getHtmlForm().setNoValidate(value);
    }
}

