/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.HtmlMenu;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLListElement;

@JsxClass(domClass=HtmlMenu.class)
public class HTMLMenuElement
extends HTMLListElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLMenuElement() {
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public String getType() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_EMPTY)) {
            return "";
        }
        String type = this.getDomNodeOrDie().getAttributeDirect("type");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_PASS)) {
            return type;
        }
        if ("context".equalsIgnoreCase(type)) {
            return "context";
        }
        if ("toolbar".equalsIgnoreCase(type)) {
            return "toolbar";
        }
        return "list";
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setType(String type) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_EMPTY)) {
            if (StringUtils.isEmpty(type)) {
                return;
            }
            throw Context.reportRuntimeError("Cannot set the type property to invalid value: '" + type + "'");
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_PASS)) {
            this.getDomNodeOrDie().setAttribute("type", type);
            return;
        }
        if ("context".equalsIgnoreCase(type)) {
            this.getDomNodeOrDie().setAttribute("type", "context");
            return;
        }
        if ("toolbar".equalsIgnoreCase(type)) {
            this.getDomNodeOrDie().setAttribute("type", "toolbar");
            return;
        }
        this.getDomNodeOrDie().setAttribute("type", "list");
    }
}

