/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.HtmlMeter;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.LabelsNodeList;

@JsxClass(domClass=HtmlMeter.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class HTMLMeterElement
extends HTMLElement {
    private NodeList labels_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLMeterElement() {
    }

    @Override
    @JsxGetter
    public Double getValue() {
        return this.getAttributeAsDouble("value", 0.0);
    }

    @JsxGetter
    public double getMin() {
        return this.getAttributeAsDouble("min", 0.0);
    }

    @JsxGetter
    public double getMax() {
        return this.getAttributeAsDouble("max", 1.0);
    }

    @JsxGetter
    public double getLow() {
        double val = this.getAttributeAsDouble("low", Double.MAX_VALUE);
        if (val == Double.MAX_VALUE) {
            return this.getMin();
        }
        return val;
    }

    @JsxGetter
    public double getHigh() {
        double val = this.getAttributeAsDouble("high", Double.MIN_VALUE);
        if (val == Double.MIN_VALUE) {
            return this.getMax();
        }
        return val;
    }

    @JsxGetter
    public double getOptimum() {
        double val = this.getAttributeAsDouble("optimum", Double.MAX_VALUE);
        if (val == Double.MAX_VALUE) {
            return this.getValue();
        }
        return val;
    }

    private double getAttributeAsDouble(String attributeName, double defaultValue) {
        try {
            return Double.parseDouble(this.getDomNodeOrDie().getAttribute(attributeName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }
}

