/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableCell;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLTableComponent;

@JsxClass(domClass=HtmlTableRow.class)
public class HTMLTableRowElement
extends HTMLTableComponent {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLTableRowElement() {
    }

    @JsxGetter
    public int getRowIndex() {
        HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
        HtmlTable table = row.getEnclosingTable();
        if (table == null) {
            return -1;
        }
        return table.getRows().indexOf(row);
    }

    @JsxGetter
    public int getSectionRowIndex() {
        DomNode row = this.getDomNodeOrDie();
        HtmlTable table = ((HtmlTableRow)row).getEnclosingTable();
        if (table == null) {
            return -1;
        }
        int index = -1;
        while (row != null) {
            if (row instanceof HtmlTableRow) {
                ++index;
            }
            row = row.getPreviousSibling();
        }
        return index;
    }

    @JsxGetter
    public Object getCells() {
        HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
        HTMLCollection cells = new HTMLCollection((DomNode)row, false);
        cells.setElementsSupplier((Supplier<List> & Serializable)() -> new ArrayList<HtmlTableCell>(row.getCells()));
        return cells;
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxFunction
    public Object insertCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (!Undefined.isUndefined(index)) {
            position = (int)Context.toNumber(index);
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (indexValid) {
            DomElement newCell = ((HtmlPage)htmlRow.getPage()).createElement("td");
            if (position == -1 || position == htmlRow.getCells().size()) {
                htmlRow.appendChild(newCell);
            } else {
                htmlRow.getCell(position).insertBefore(newCell);
            }
            return this.getScriptableFor(newCell);
        }
        throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount");
    }

    @JsxFunction
    public void deleteCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (!Undefined.isUndefined(index)) {
            position = (int)Context.toNumber(index);
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_ROW_DELETE_CELL_REQUIRES_INDEX)) {
            throw Context.reportRuntimeError("No enough arguments");
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        if (position == -1) {
            position = htmlRow.getCells().size() - 1;
        }
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (!indexValid) {
            throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount");
        }
        htmlRow.getCell(position).remove();
    }

    @Override
    public void setOuterHTML(Object value) {
        throw Context.reportRuntimeError("outerHTML is read-only for tag 'tr'");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColor() {
        return this.getDomNodeOrDie().getAttribute("borderColor");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColor(String borderColor) {
        this.setColorAttribute("borderColor", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorDark() {
        return this.getDomNodeOrDie().getAttribute("borderColorDark");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorDark(String borderColor) {
        this.setColorAttribute("borderColorDark", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorLight() {
        return this.getDomNodeOrDie().getAttribute("borderColorLight");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorLight(String borderColor) {
        this.setColorAttribute("borderColorLight", borderColor);
    }
}

