/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.History;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.XmlSerializer;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.event.BeforeUnloadEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;

public class HtmlPage
extends InteractivePage {
    private static final Log LOG = LogFactory.getLog(HtmlPage.class);
    private static final Comparator<DomElement> documentPositionComparator = new DocumentPositionComparator();
    private HTMLParser.HtmlUnitDOMBuilder builder_;
    private String originalCharset_;
    private Map<String, SortedSet<DomElement>> idMap_ = Collections.synchronizedMap(new HashMap());
    private Map<String, SortedSet<DomElement>> nameMap_ = Collections.synchronizedMap(new HashMap());
    private SortedSet<BaseFrameElement> frameElements_ = new TreeSet<DomElement>(documentPositionComparator);
    private int parserCount_;
    private int snippetParserCount_;
    private int inlineSnippetParserCount_;
    private Collection<HtmlAttributeChangeListener> attributeListeners_;
    private final Object lock_ = new String();
    private List<PostponedAction> afterLoadActions_ = new ArrayList<PostponedAction>();
    private boolean cleaning_;
    private HtmlBase base_;
    private URL baseUrl_;

    public HtmlPage(URL originatingUrl, WebResponse webResponse, WebWindow webWindow) {
        super(webResponse, webWindow);
    }

    @Override
    public HtmlPage getPage() {
        return this;
    }

    @Override
    public boolean hasCaseSensitiveTagNames() {
        return false;
    }

    @Override
    public void initialize() throws IOException, FailingHttpStatusCodeException {
        boolean isAboutBlank;
        WebWindow enclosingWindow = this.getEnclosingWindow();
        boolean bl = isAboutBlank = this.getUrl() == WebClient.URL_ABOUT_BLANK;
        if (isAboutBlank) {
            TopLevelWindow topWindow;
            WebWindow openerWindow;
            if (enclosingWindow instanceof FrameWindow && !((FrameWindow)enclosingWindow).getFrameElement().isContentLoaded()) {
                return;
            }
            if (enclosingWindow instanceof TopLevelWindow && (openerWindow = (topWindow = (TopLevelWindow)enclosingWindow).getOpener()) != null && openerWindow.getEnclosedPage() != null) {
                this.baseUrl_ = openerWindow.getEnclosedPage().getWebResponse().getWebRequest().getUrl();
            }
        }
        this.loadFrames();
        if (!isAboutBlank) {
            if (this.hasFeature(BrowserVersionFeatures.FOCUS_BODY_ELEMENT_AT_START)) {
                this.setElementWithFocus(this.getBody());
            }
            this.setReadyState("complete");
            this.getDocumentElement().setReadyState("complete");
        }
        if (this.hasFeature(BrowserVersionFeatures.EVENT_DOM_CONTENT_LOADED)) {
            this.executeEventHandlersIfNeeded("DOMContentLoaded");
        }
        this.executeDeferredScriptsIfNeeded();
        this.setReadyStateOnDeferredScriptsIfNeeded();
        boolean isFrameWindow = enclosingWindow instanceof FrameWindow;
        boolean isFirstPageInFrameWindow = false;
        if (isFrameWindow) {
            isFrameWindow = ((FrameWindow)enclosingWindow).getFrameElement() instanceof HtmlFrame;
            History hist = enclosingWindow.getHistory();
            if (hist.getLength() > 0 && WebClient.URL_ABOUT_BLANK == hist.getUrl(0)) {
                isFirstPageInFrameWindow = hist.getLength() <= 2;
            } else {
                boolean bl2 = isFirstPageInFrameWindow = enclosingWindow.getHistory().getLength() < 2;
            }
        }
        if (isFrameWindow && !isFirstPageInFrameWindow) {
            this.executeEventHandlersIfNeeded("load");
        }
        for (FrameWindow frameWindow : this.getFrames()) {
            Page page;
            if (!(frameWindow.getFrameElement() instanceof HtmlFrame) || (page = frameWindow.getEnclosedPage()) == null || !page.isHtmlPage()) continue;
            ((HtmlPage)page).executeEventHandlersIfNeeded("load");
        }
        if (!isFrameWindow) {
            this.executeEventHandlersIfNeeded("load");
        }
        ArrayList<PostponedAction> actions = new ArrayList<PostponedAction>(this.afterLoadActions_);
        this.afterLoadActions_.clear();
        try {
            for (PostponedAction action : actions) {
                action.execute();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.executeRefreshIfNeeded();
    }

    void addAfterLoadAction(PostponedAction action) {
        this.afterLoadActions_.add(action);
    }

    @Override
    public void cleanUp() {
        if (this.cleaning_) {
            return;
        }
        this.cleaning_ = true;
        super.cleanUp();
        this.executeEventHandlersIfNeeded("unload");
        this.deregisterFramesIfNeeded();
        this.cleaning_ = false;
    }

    @Override
    public HtmlElement getDocumentElement() {
        return (HtmlElement)super.getDocumentElement();
    }

    public HtmlElement getBody() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlBody) && !(node instanceof HtmlFrameSet)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    public HtmlElement getHead() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlHead)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) {
        throw new UnsupportedOperationException("HtmlPage.importNode is not yet implemented.");
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getInputEncoding is not yet implemented.");
    }

    @Override
    public String getXmlEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getXmlEncoding is not yet implemented.");
    }

    @Override
    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("HtmlPage.getXmlStandalone is not yet implemented.");
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlStandalone is not yet implemented.");
    }

    @Override
    public String getXmlVersion() {
        throw new UnsupportedOperationException("HtmlPage.getXmlVersion is not yet implemented.");
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlVersion is not yet implemented.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("HtmlPage.getStrictErrorChecking is not yet implemented.");
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("HtmlPage.setStrictErrorChecking is not yet implemented.");
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("HtmlPage.getDocumentURI is not yet implemented.");
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("HtmlPage.setDocumentURI is not yet implemented.");
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.adoptNode is not yet implemented.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("HtmlPage.getDomConfig is not yet implemented.");
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node newNode, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.renameNode is not yet implemented.");
    }

    @Override
    public String getPageEncoding() {
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.getWebResponse().getContentCharset();
        }
        return this.originalCharset_;
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("HtmlPage.getImplementation is not yet implemented.");
    }

    @Override
    public DomElement createElement(String tagName) {
        if (tagName.indexOf(58) == -1) {
            tagName = tagName.toLowerCase(Locale.ENGLISH);
        }
        return HTMLParser.getFactory(tagName).createElementNS(this, null, tagName, null, true);
    }

    @Override
    public DomElement createElementNS(String namespaceURI, String qualifiedName) {
        return HTMLParser.getElementFactory(this, namespaceURI, qualifiedName).createElementNS(this, namespaceURI, qualifiedName, null, true);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createAttributeNS is not yet implemented.");
    }

    @Override
    public EntityReference createEntityReference(String id) {
        throw new UnsupportedOperationException("HtmlPage.createEntityReference is not yet implemented.");
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createProcessingInstruction is not yet implemented.");
    }

    @Override
    public DomNodeList<DomElement> getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("HtmlPage.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public DomElement getElementById(String elementId) {
        try {
            return this.getElementById(elementId, true);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List<HtmlAnchor> getAnchors() {
        return this.getDocumentElement().getHtmlElementsByTagName("a");
    }

    public HtmlAnchor getAnchorByText(String text) throws ElementNotFoundException {
        WebAssert.notNull("text", text);
        for (HtmlAnchor anchor : this.getAnchors()) {
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getDocumentElement().getElementsByAttribute("form", "name", name);
        if (forms.size() == 0) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List<HtmlForm> getForms() {
        return this.getDocumentElement().getHtmlElementsByTagName("form");
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        URL baseUrl;
        if (this.base_ == null) {
            boolean frame;
            baseUrl = this.getUrl();
            WebWindow window = this.getEnclosingWindow();
            boolean bl = frame = window != window.getTopWindow();
            if (frame) {
                boolean frameSrcIsNotSet = baseUrl == WebClient.URL_ABOUT_BLANK;
                boolean frameSrcIsJs = "javascript".equals(baseUrl.getProtocol());
                if (frameSrcIsNotSet || frameSrcIsJs) {
                    baseUrl = ((HtmlPage)window.getTopWindow().getEnclosedPage()).getWebResponse().getWebRequest().getUrl();
                }
            } else if (this.baseUrl_ != null) {
                baseUrl = this.baseUrl_;
            }
        } else {
            boolean insideHead = false;
            for (DomNode parent = this.base_.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof HtmlHead)) continue;
                insideHead = true;
                break;
            }
            if (!insideHead) {
                this.notifyIncorrectness("Element 'base' must appear in <head>, it is ignored.");
            }
            String href = this.base_.getHrefAttribute();
            if (!insideHead || StringUtils.isEmpty((CharSequence)href)) {
                baseUrl = this.getUrl();
            } else {
                try {
                    baseUrl = new URL(href);
                }
                catch (MalformedURLException e) {
                    this.notifyIncorrectness("Invalid base url: \"" + href + "\", ignoring it");
                    baseUrl = this.getUrl();
                }
            }
        }
        if (this.hasFeature(BrowserVersionFeatures.URL_MISSING_SLASHES)) {
            boolean incorrectnessNotified = false;
            while (relativeUrl.startsWith("http:") && !relativeUrl.startsWith("http://")) {
                if (!incorrectnessNotified) {
                    this.notifyIncorrectness("Incorrect URL \"" + relativeUrl + "\" has been corrected");
                    incorrectnessNotified = true;
                }
                relativeUrl = "http:/" + relativeUrl.substring(5);
            }
        }
        return WebClient.expandUrl(baseUrl, relativeUrl);
    }

    public String getResolvedTarget(String elementTarget) {
        String resolvedTarget = this.base_ == null ? elementTarget : (elementTarget != null && !elementTarget.isEmpty() ? elementTarget : this.base_.getTargetAttribute());
        return resolvedTarget;
    }

    public List<String> getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlElement element : this.getTabbableElements()) {
            list.add(element.getAttribute("id"));
        }
        return Collections.unmodifiableList(list);
    }

    public List<HtmlElement> getTabbableElements() {
        List<String> tags = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            boolean disabled;
            String tagName = element.getTagName();
            if (!tags.contains(tagName) || (disabled = element.hasAttribute("disabled")) || element.getTabIndex() == HtmlElement.TAB_INDEX_OUT_OF_BOUNDS) continue;
            tabbableElements.add(element);
        }
        Collections.sort(tabbableElements, this.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private Comparator<HtmlElement> createTabOrderComparator() {
        return new Comparator<HtmlElement>(){

            @Override
            public int compare(HtmlElement element1, HtmlElement element2) {
                Short i1 = element1.getTabIndex();
                Short i2 = element2.getTabIndex();
                int index1 = i1 != null ? (int)i1.shortValue() : -1;
                int index2 = i2 != null ? (int)i2.shortValue() : -1;
                int result = index1 > 0 && index2 > 0 ? index1 - index2 : (index1 > 0 ? -1 : (index2 > 0 ? 1 : (index1 == index2 ? 0 : index2 - index1)));
                return result;
            }
        };
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List<HtmlElement> elements = this.getHtmlElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public List<HtmlElement> getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = Character.toString(accessKey).toLowerCase(Locale.ENGLISH);
        List<String> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            String accessKeyAttribute;
            if (!acceptableTagNames.contains(element.getTagName()) || !searchString.equalsIgnoreCase(accessKeyAttribute = element.getAttribute("accesskey"))) continue;
            elements.add(element);
        }
        return elements;
    }

    public ScriptResult executeJavaScript(String sourceCode) {
        return this.executeJavaScriptIfPossible(sourceCode, "injected script", 1);
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, int startLine) {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)sourceCode, (CharSequence)"javascript:")) {
            sourceCode = sourceCode.substring("javascript:".length());
        }
        Object result = this.getWebClient().getJavaScriptEngine().execute(this, sourceCode, sourceName, startLine);
        return new ScriptResult(result, this.getWebClient().getCurrentWindow().getEnclosedPage());
    }

    JavaScriptLoadResult loadExternalJavaScriptFile(String srcAttribute, String charset) throws FailingHttpStatusCodeException {
        Script script;
        URL scriptURL;
        WebClient client = this.getWebClient();
        if (StringUtils.isBlank((CharSequence)srcAttribute) || !client.getOptions().isJavaScriptEnabled()) {
            return JavaScriptLoadResult.NOOP;
        }
        try {
            scriptURL = this.getFullyQualifiedUrl(srcAttribute);
            String protocol = scriptURL.getProtocol();
            if ("javascript".equals(protocol)) {
                LOG.info((Object)("Ignoring script src [" + srcAttribute + "]"));
                return JavaScriptLoadResult.NOOP;
            }
            if (!("http".equals(protocol) || "https".equals(protocol) || "data".equals(protocol) || "file".equals(protocol))) {
                LOG.error((Object)("Unable to build URL for script src tag [" + srcAttribute + "] (protocol: " + protocol + ")"));
                JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
                if (javaScriptErrorListener != null) {
                    javaScriptErrorListener.malformedScriptURL(this, srcAttribute, new MalformedURLException("unknown protocol: " + protocol));
                }
                return JavaScriptLoadResult.NOOP;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Unable to build URL for script src tag [" + srcAttribute + "]"));
            JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
            if (javaScriptErrorListener != null) {
                javaScriptErrorListener.malformedScriptURL(this, srcAttribute, e);
            }
            return JavaScriptLoadResult.NOOP;
        }
        try {
            script = this.loadJavaScriptFromUrl(scriptURL, charset);
        }
        catch (IOException e) {
            LOG.error((Object)("Error loading JavaScript from [" + scriptURL + "]."), (Throwable)e);
            JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
            if (javaScriptErrorListener != null) {
                javaScriptErrorListener.loadScriptError(this, scriptURL, e);
            }
            return JavaScriptLoadResult.DOWNLOAD_ERROR;
        }
        catch (FailingHttpStatusCodeException e) {
            LOG.error((Object)("Error loading JavaScript from [" + scriptURL + "]."), (Throwable)e);
            JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
            if (javaScriptErrorListener != null) {
                javaScriptErrorListener.loadScriptError(this, scriptURL, e);
            }
            throw e;
        }
        if (script == null) {
            return JavaScriptLoadResult.COMPILATION_ERROR;
        }
        client.getJavaScriptEngine().execute(this, script);
        return JavaScriptLoadResult.SUCCESS;
    }

    private Script loadJavaScriptFromUrl(URL url, String charset) throws IOException, FailingHttpStatusCodeException {
        boolean noContent;
        String scriptEncoding = charset;
        String pageEncoding = this.getPageEncoding();
        WebRequest referringRequest = this.getWebResponse().getWebRequest();
        WebClient client = this.getWebClient();
        Cache cache = client.getCache();
        WebRequest request = new WebRequest(url, this.getWebClient().getBrowserVersion().getScriptAcceptHeader());
        request.setAdditionalHeaders(new HashMap<String, String>(referringRequest.getAdditionalHeaders()));
        request.setAdditionalHeader("Referer", referringRequest.getUrl().toString());
        request.setAdditionalHeader("Accept", client.getBrowserVersion().getScriptAcceptHeader());
        WebResponse response = client.loadWebResponse(request);
        Object cachedScript = cache.getCachedObject(request);
        if (cachedScript instanceof Script) {
            return (Script)cachedScript;
        }
        client.printContentIfNecessary(response);
        client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
        int statusCode = response.getStatusCode();
        boolean successful = statusCode >= 200 && statusCode < 300;
        boolean bl = noContent = statusCode == 204;
        if (!successful || noContent) {
            throw new IOException("Unable to download JavaScript from '" + url + "' (status " + statusCode + ").");
        }
        String contentType = response.getContentType();
        if (!"application/javascript".equalsIgnoreCase(contentType) && !"application/ecmascript".equalsIgnoreCase(contentType)) {
            if ("text/javascript".equals(contentType) || "text/ecmascript".equals(contentType) || "application/x-javascript".equalsIgnoreCase(contentType)) {
                this.getWebClient().getIncorrectnessListener().notify("Obsolete content type encountered: '" + contentType + "'.", this);
            } else {
                this.getWebClient().getIncorrectnessListener().notify("Expected content type of 'application/javascript' or 'application/ecmascript' for remotely loaded JavaScript element at '" + url + "', " + "but got '" + contentType + "'.", this);
            }
        }
        if (StringUtils.isEmpty((CharSequence)scriptEncoding)) {
            String contentCharset = response.getContentCharset();
            scriptEncoding = !contentCharset.equals("ISO-8859-1") ? contentCharset : (!pageEncoding.equals("ISO-8859-1") ? pageEncoding : "ISO-8859-1");
        }
        String scriptCode = response.getContentAsString(scriptEncoding);
        response.cleanUp();
        if (null != scriptCode) {
            JavaScriptEngine javaScriptEngine = client.getJavaScriptEngine();
            Script script = javaScriptEngine.compile(this, scriptCode, url.toExternalForm(), 1);
            if (script != null) {
                cache.cacheIfPossible(request, response, script);
            }
            return script;
        }
        return null;
    }

    public String getTitleText() {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement != null) {
            return titleElement.asText();
        }
        return "";
    }

    public void setTitleText(String message) {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement == null) {
            HtmlHead head;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No title element, creating one");
            }
            if ((head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class)) == null) {
                throw new IllegalStateException("Headelement was not defined for this page");
            }
            Map<String, DomAttr> emptyMap = Collections.emptyMap();
            titleElement = new HtmlTitle("title", this, emptyMap);
            if (head.getFirstChild() != null) {
                head.getFirstChild().insertBefore(titleElement);
            } else {
                head.appendChild(titleElement);
            }
        }
        titleElement.setNodeValue(message);
    }

    private DomElement getFirstChildElement(DomElement startElement, Class<?> clazz) {
        if (startElement == null) {
            return null;
        }
        for (DomElement element : startElement.getChildElements()) {
            if (!clazz.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    private DomElement getFirstChildElementRecursive(DomElement startElement, Class<?> clazz) {
        if (startElement == null) {
            return null;
        }
        for (DomElement element : startElement.getChildElements()) {
            if (clazz.isInstance(element)) {
                return element;
            }
            DomElement childFound = this.getFirstChildElementRecursive(element, clazz);
            if (childFound == null) continue;
            return childFound;
        }
        return null;
    }

    private HtmlTitle getTitleElement() {
        return (HtmlTitle)this.getFirstChildElementRecursive(this.getDocumentElement(), HtmlTitle.class);
    }

    private boolean executeEventHandlersIfNeeded(String eventType) {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return true;
        }
        WebWindow window = this.getEnclosingWindow();
        Window jsWindow = (Window)window.getScriptObject();
        if (jsWindow != null) {
            HtmlElement element = this.getDocumentElement();
            if (element == null) {
                return true;
            }
            Event event = eventType.equals("beforeunload") && !this.hasFeature(BrowserVersionFeatures.EVENT_ONBEFOREUNLOAD_USES_EVENT) ? new BeforeUnloadEvent(element, eventType) : new Event(element, eventType);
            element.fireEvent(event);
            if (!this.isOnbeforeunloadAccepted(this, event)) {
                return false;
            }
        }
        if (window instanceof FrameWindow) {
            BaseFrameElement frame;
            if ("load".equals(eventType) && !this.hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_IFRAME_CREATED_BY_JAVASCRIPT) && (frame = ((FrameWindow)window).getFrameElement()).wasCreatedByJavascript()) {
                return true;
            }
            FrameWindow fw = (FrameWindow)window;
            BaseFrameElement frame2 = fw.getFrameElement();
            if ("load".equals(eventType) && frame2.getParentNode() instanceof DomDocumentFragment) {
                return true;
            }
            if (frame2.hasEventHandlers("on" + eventType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing on" + eventType + " handler for " + frame2));
                }
                Event event = eventType.equals("beforeunload") && !this.hasFeature(BrowserVersionFeatures.EVENT_ONBEFOREUNLOAD_USES_EVENT) ? new BeforeUnloadEvent(frame2, eventType) : new Event(frame2, eventType);
                ((Node)frame2.getScriptObject()).executeEvent(event);
                if (!this.isOnbeforeunloadAccepted((HtmlPage)frame2.getPage(), event)) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isOnbeforeunloadAccepted() {
        return this.executeEventHandlersIfNeeded("beforeunload");
    }

    private boolean isOnbeforeunloadAccepted(HtmlPage page, Event event) {
        if (event.getType().equals("beforeunload") && event.getReturnValue() != null) {
            OnbeforeunloadHandler handler = this.getWebClient().getOnbeforeunloadHandler();
            if (handler == null) {
                LOG.warn((Object)"document.onbeforeunload() returned a string in event.returnValue, but no onbeforeunload handler installed.");
            } else {
                String message = Context.toString(event.getReturnValue());
                return handler.handleEvent(page, message);
            }
        }
        return true;
    }

    private void executeRefreshIfNeeded() throws IOException {
        URL url;
        double time;
        boolean timeOnly;
        WebWindow window = this.getEnclosingWindow();
        if (window == null) {
            return;
        }
        String refreshString = this.getRefreshStringOrNull();
        if (refreshString == null || refreshString.isEmpty()) {
            return;
        }
        int index = StringUtils.indexOfAnyBut((CharSequence)refreshString, (CharSequence)"0123456789");
        boolean bl = timeOnly = index == -1;
        if (timeOnly) {
            try {
                time = Double.parseDouble(refreshString);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Malformed refresh string (no ';' but not a number): " + refreshString), (Throwable)e);
                return;
            }
            url = this.getUrl();
        } else {
            try {
                time = Double.parseDouble(refreshString.substring(0, index).trim());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Malformed refresh string (no valid number before ';') " + refreshString), (Throwable)e);
                return;
            }
            index = refreshString.toLowerCase(Locale.ENGLISH).indexOf("url=", index);
            if (index == -1) {
                LOG.error((Object)("Malformed refresh string (found ';' but no 'url='): " + refreshString));
                return;
            }
            StringBuilder buffer = new StringBuilder(refreshString.substring(index + 4));
            if (StringUtils.isBlank((CharSequence)buffer.toString())) {
                url = this.getUrl();
            } else {
                if (buffer.charAt(0) == '\"' || buffer.charAt(0) == '\'') {
                    buffer.deleteCharAt(0);
                }
                if (buffer.charAt(buffer.length() - 1) == '\"' || buffer.charAt(buffer.length() - 1) == '\'') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                String urlString = buffer.toString();
                try {
                    url = this.getFullyQualifiedUrl(urlString);
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)("Malformed URL in refresh string: " + refreshString), (Throwable)e);
                    throw e;
                }
            }
        }
        int timeRounded = (int)time;
        this.getWebClient().getRefreshHandler().handleRefresh(this, url, timeRounded);
    }

    private String getRefreshStringOrNull() {
        Iterator<HtmlMeta> i$ = this.getMetaTags("refresh").iterator();
        if (i$.hasNext()) {
            HtmlMeta meta = i$.next();
            return meta.getContentAttribute().trim();
        }
        return this.getWebResponse().getResponseHeaderValue("Refresh");
    }

    private void executeDeferredScriptsIfNeeded() {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return;
        }
        if (this.hasFeature(BrowserVersionFeatures.JS_DEFERRED)) {
            HtmlElement doc = this.getDocumentElement();
            List elements = doc.getHtmlElementsByTagName("script");
            for (HtmlElement e : elements) {
                HtmlScript script;
                if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred()) continue;
                script.executeScriptIfNeeded();
            }
        }
    }

    private void setReadyStateOnDeferredScriptsIfNeeded() {
        if (this.getWebClient().getOptions().isJavaScriptEnabled() && this.hasFeature(BrowserVersionFeatures.JS_DEFERRED)) {
            List elements = this.getDocumentElement().getHtmlElementsByTagName("script");
            for (HtmlElement e : elements) {
                HtmlScript script;
                if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred()) continue;
                script.setAndExecuteReadyState("complete");
            }
        }
    }

    public void deregisterFramesIfNeeded() {
        for (WebWindow webWindow : this.getFrames()) {
            this.getWebClient().deregisterWebWindow(webWindow);
            Page page = webWindow.getEnclosedPage();
            if (page == null || !page.isHtmlPage()) continue;
            ((HtmlPage)page).deregisterFramesIfNeeded();
        }
    }

    public List<FrameWindow> getFrames() {
        ArrayList<FrameWindow> list = new ArrayList<FrameWindow>(this.frameElements_.size());
        for (BaseFrameElement frameElement : this.frameElements_) {
            list.add(frameElement.getEnclosedWindow());
        }
        return list;
    }

    public FrameWindow getFrameByName(String name) throws ElementNotFoundException {
        for (FrameWindow frame : this.getFrames()) {
            if (!frame.getName().equals(name)) continue;
            return frame;
        }
        throw new ElementNotFoundException("frame or iframe", "name", name);
    }

    public DomElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getHtmlElementByAccessKey(accessKey);
        if (element != null) {
            element.focus();
            Object newPage = element instanceof HtmlAnchor ? ((HtmlAnchor)element).click() : (element instanceof HtmlArea ? ((HtmlArea)element).click() : (element instanceof HtmlButton ? ((HtmlButton)element).click() : (element instanceof HtmlInput ? ((HtmlInput)element).click() : (element instanceof HtmlLabel ? ((HtmlLabel)element).click() : (element instanceof HtmlLegend ? ((HtmlLegend)element).click() : (element instanceof HtmlTextArea ? ((HtmlTextArea)element).click() : this))))));
            if (newPage != this && this.getFocusedElement() == element) {
                this.getFocusedElement().blur();
            }
        }
        return this.getFocusedElement();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(0) : (index == elements.size() - 1 ? elements.get(0) : elements.get(index + 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(elements.size() - 1) : (index == 0 ? elements.get(elements.size() - 1) : elements.get(index - 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public <E extends HtmlElement> E getHtmlElementById(String id) throws ElementNotFoundException {
        return (E)((HtmlElement)this.getElementById(id, true));
    }

    public <E extends HtmlElement> E getHtmlElementById(String id, boolean caseSensitive) throws ElementNotFoundException {
        return (E)((HtmlElement)this.getElementById(id, caseSensitive));
    }

    public <E extends DomElement> E getElementById(String id, boolean caseSensitive) throws ElementNotFoundException {
        SortedSet<DomElement> elements = this.idMap_.get(id);
        if (null == elements && !caseSensitive) {
            for (String key : this.idMap_.keySet()) {
                if (!key.equalsIgnoreCase(id)) continue;
                elements = this.idMap_.get(key);
                break;
            }
        }
        if (elements != null) {
            return (E)elements.first();
        }
        throw new ElementNotFoundException("*", "id", id);
    }

    public <E extends DomElement> E getElementByName(String name) throws ElementNotFoundException {
        SortedSet<DomElement> elements = this.nameMap_.get(name);
        if (elements != null) {
            return (E)elements.first();
        }
        throw new ElementNotFoundException("*", "name", name);
    }

    public List<DomElement> getElementsByName(String name) {
        SortedSet<DomElement> elements = this.nameMap_.get(name);
        if (elements != null) {
            return new ArrayList<DomElement>(elements);
        }
        return Collections.emptyList();
    }

    public List<DomElement> getElementsByIdAndOrName(String idAndOrName) {
        Collection list1 = this.idMap_.get(idAndOrName);
        Collection list2 = this.nameMap_.get(idAndOrName);
        ArrayList<DomElement> list = new ArrayList<DomElement>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            for (DomElement elt : list2) {
                if (list.contains(elt)) continue;
                list.add(elt);
            }
        }
        return list;
    }

    void notifyNodeAdded(DomNode node) {
        if (node instanceof DomElement) {
            this.addMappedElement((DomElement)node, true);
            if (node instanceof BaseFrameElement) {
                this.frameElements_.add((BaseFrameElement)node);
            }
            for (HtmlElement child : node.getHtmlElementDescendants()) {
                if (!(child instanceof BaseFrameElement)) continue;
                this.frameElements_.add((BaseFrameElement)child);
            }
            if ("base".equals(node.getNodeName())) {
                this.calculateBase();
            }
        }
        node.onAddedToPage();
    }

    void notifyNodeRemoved(DomNode node) {
        if (node instanceof HtmlElement) {
            this.removeMappedElement((HtmlElement)node, true, true);
            if (node instanceof BaseFrameElement) {
                this.frameElements_.remove(node);
            }
            for (HtmlElement child : node.getHtmlElementDescendants()) {
                if (!(child instanceof BaseFrameElement)) continue;
                this.frameElements_.remove(child);
            }
            if ("base".equals(node.getNodeName())) {
                this.calculateBase();
            }
        }
    }

    void addMappedElement(DomElement element) {
        this.addMappedElement(element, false);
    }

    void addMappedElement(DomElement element, boolean recurse) {
        if (this.isDescendant(element)) {
            this.addElement(this.idMap_, element, "id", recurse);
            this.addElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void addElement(Map<String, SortedSet<DomElement>> map, DomElement element, String attribute, boolean recurse) {
        Object jsValue;
        ScriptableObject scriptObject;
        String value = element.getAttribute(attribute);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value && !(element instanceof HtmlApplet) && (scriptObject = element.getScriptObject()).has(attribute, (Scriptable)scriptObject) && (jsValue = scriptObject.get(attribute, (Scriptable)scriptObject)) != null && jsValue != Scriptable.NOT_FOUND && jsValue instanceof String) {
            value = (String)jsValue;
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != value) {
            SortedSet<DomElement> elements = map.get(value);
            if (elements == null) {
                elements = new TreeSet<DomElement>(documentPositionComparator);
                elements.add(element);
                map.put(value, elements);
            } else if (!elements.contains(element)) {
                elements.add(element);
            }
        }
        if (recurse) {
            for (DomElement child : element.getChildElements()) {
                this.addElement(map, child, attribute, true);
            }
        }
    }

    void removeMappedElement(HtmlElement element) {
        this.removeMappedElement(element, false, false);
    }

    void removeMappedElement(DomElement element, boolean recurse, boolean descendant) {
        if (descendant || this.isDescendant(element)) {
            this.removeElement(this.idMap_, element, "id", recurse);
            this.removeElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void removeElement(Map<String, SortedSet<DomElement>> map, DomElement element, String attribute, boolean recurse) {
        SortedSet<DomElement> elements;
        Object jsValue;
        ScriptableObject scriptObject;
        String value = element.getAttribute(attribute);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value && !(element instanceof HtmlApplet) && (scriptObject = element.getScriptObject()).has(attribute, (Scriptable)scriptObject) && (jsValue = scriptObject.get(attribute, (Scriptable)scriptObject)) != null && jsValue != Scriptable.NOT_FOUND && jsValue instanceof String) {
            value = (String)jsValue;
        }
        if (!(StringUtils.isEmpty((CharSequence)value) || (elements = map.remove(value)) == null || elements.size() == 1 && elements.contains(element))) {
            elements.remove(element);
            map.put(value, elements);
        }
        if (recurse) {
            for (DomElement child : element.getChildElements()) {
                this.removeElement(map, child, attribute, true);
            }
        }
    }

    static boolean isMappedElement(Document document, String attributeName) {
        return document instanceof HtmlPage && ("name".equals(attributeName) || "id".equals(attributeName));
    }

    private void calculateBase() {
        List baseElements = this.getDocumentElement().getHtmlElementsByTagName("base");
        switch (baseElements.size()) {
            case 0: {
                this.base_ = null;
                break;
            }
            case 1: {
                this.base_ = (HtmlBase)baseElements.get(0);
                break;
            }
            default: {
                this.base_ = (HtmlBase)baseElements.get(0);
                this.notifyIncorrectness("Multiple 'base' detected, only the first is used.");
            }
        }
    }

    void loadFrames() throws FailingHttpStatusCodeException {
        for (FrameWindow w : this.getFrames()) {
            BaseFrameElement frame = w.getFrameElement();
            if (frame.getEnclosedWindow() == null || WebClient.URL_ABOUT_BLANK != frame.getEnclosedPage().getUrl() || frame.isContentLoaded()) continue;
            frame.loadInnerPage();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("HtmlPage(");
        buffer.append(this.getUrl());
        buffer.append(")@");
        buffer.append(this.hashCode());
        return buffer.toString();
    }

    protected List<HtmlMeta> getMetaTags(String httpEquiv) {
        if (this.getDocumentElement() == null) {
            return Collections.emptyList();
        }
        String nameLC = httpEquiv.toLowerCase(Locale.ENGLISH);
        List<HtmlMeta> tags = this.getDocumentElement().getHtmlElementsByTagName("meta");
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            HtmlMeta element = (HtmlMeta)iter.next();
            if (nameLC.equals(element.getHttpEquivAttribute().toLowerCase(Locale.ENGLISH))) continue;
            iter.remove();
        }
        return tags;
    }

    @Override
    protected HtmlPage clone() {
        HtmlPage result = (HtmlPage)super.clone();
        result.idMap_ = Collections.synchronizedMap(new HashMap());
        result.nameMap_ = Collections.synchronizedMap(new HashMap());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlPage cloneNode(boolean deep) {
        HtmlPage result = (HtmlPage)super.cloneNode(deep);
        if (deep) {
            Object object = this.lock_;
            synchronized (object) {
                result.attributeListeners_ = null;
            }
            result.afterLoadActions_ = new ArrayList<PostponedAction>();
            result.frameElements_ = new TreeSet<DomElement>(documentPositionComparator);
            for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                result.appendChild(child.cloneNode(true));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new LinkedHashSet<HtmlAttributeChangeListener>();
            }
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeAdded(event);
            }
        }
    }

    void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeReplaced(event);
            }
        }
    }

    void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HtmlAttributeChangeListener> safeGetAttributeListeners() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                return new ArrayList<HtmlAttributeChangeListener>(this.attributeListeners_);
            }
            return null;
        }
    }

    @Override
    protected void checkChildHierarchy(org.w3c.dom.Node newChild) throws DOMException {
        if (newChild instanceof Element) {
            if (this.getDocumentElement() != null) {
                throw new DOMException(3, "The Document may only have a single child Element.");
            }
        } else if (newChild instanceof DocumentType) {
            if (this.getDoctype() != null) {
                throw new DOMException(3, "The Document may only have a single child DocumentType.");
            }
        } else if (!(newChild instanceof Comment) && !(newChild instanceof ProcessingInstruction)) {
            throw new DOMException(3, "The Document may not have a child of this type: " + newChild.getNodeType());
        }
        super.checkChildHierarchy(newChild);
    }

    public boolean isBeingParsed() {
        return this.parserCount_ > 0;
    }

    void registerParsingStart() {
        ++this.parserCount_;
    }

    void registerParsingEnd() {
        --this.parserCount_;
    }

    boolean isParsingHtmlSnippet() {
        return this.snippetParserCount_ > 0;
    }

    void registerSnippetParsingStart() {
        ++this.snippetParserCount_;
    }

    void registerSnippetParsingEnd() {
        --this.snippetParserCount_;
    }

    boolean isParsingInlineHtmlSnippet() {
        return this.inlineSnippetParserCount_ > 0;
    }

    void registerInlineSnippetParsingStart() {
        ++this.inlineSnippetParserCount_;
    }

    void registerInlineSnippetParsingEnd() {
        --this.inlineSnippetParserCount_;
    }

    public Page refresh() throws IOException {
        return this.getWebClient().getPage(this.getWebResponse().getWebRequest());
    }

    public void writeInParsedStream(String string) {
        this.builder_.pushInputString(string);
    }

    void setBuilder(HTMLParser.HtmlUnitDOMBuilder htmlUnitDOMBuilder) {
        this.builder_ = htmlUnitDOMBuilder;
    }

    HTMLParser.HtmlUnitDOMBuilder getBuilder() {
        return this.builder_;
    }

    public Map<String, String> getNamespaces() {
        NamedNodeMap attributes = this.getDocumentElement().getAttributes();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (!name.startsWith("xmlns")) continue;
            int startPos = 5;
            if (name.length() > 5 && name.charAt(5) == ':') {
                startPos = 6;
            }
            name = name.substring(startPos);
            namespaces.put(name, attr.getValue());
        }
        return namespaces;
    }

    @Override
    protected void setDocumentType(DocumentType type) {
        super.setDocumentType(type);
        if (this.hasFeature(BrowserVersionFeatures.JS_WINDOW_IN_STANDARDS_MODE) && !this.isQuirksMode()) {
            JavaScriptEngine jsEngine = this.getWebClient().getJavaScriptEngine();
            jsEngine.definePropertiesInStandardsMode(this);
        }
    }

    public void save(File file) throws IOException {
        new XmlSerializer().save(this, file);
    }

    public boolean isQuirksMode() {
        return "BackCompat".equals(((HTMLDocument)this.getScriptObject()).getCompatMode());
    }

    @Override
    public boolean isDirectlyAttachedToPage() {
        return true;
    }

    @Override
    public boolean isHtmlPage() {
        return true;
    }

    @Override
    public HtmlElement getFocusedElement() {
        return (HtmlElement)super.getFocusedElement();
    }

    static enum JavaScriptLoadResult {
        NOOP,
        SUCCESS,
        DOWNLOAD_ERROR,
        COMPILATION_ERROR;

    }

    static class DocumentPositionComparator
    implements Comparator<DomElement>,
    Serializable {
        DocumentPositionComparator() {
        }

        @Override
        public int compare(DomElement elt1, DomElement elt2) {
            short relation = elt1.compareDocumentPosition(elt2);
            if (relation == 0) {
                return 0;
            }
            if ((relation & 8) != 0 || (relation & 2) != 0) {
                return 1;
            }
            return -1;
        }
    }
}

