/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public final class DateCustom {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static Field DATE_FIELD_;

    private DateCustom() {
    }

    public static String toLocaleDateString(Context context, Scriptable thisObj, Object[] args, Function function) {
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        String formatString = browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_LOCALE_DATE_SHORT_WITH_SPECIAL_CHARS) ? "\u200edd\u200e.\u200eMM\u200e.\u200eyyyy" : (browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_LOCALE_DATE_SHORT) ? "d.M.yyyy" : "EEEE, MMMM dd, yyyy");
        FastDateFormat format = FastDateFormat.getInstance((String)formatString, (Locale)DateCustom.getLocale(thisObj));
        return format.format(DateCustom.getDateValue(thisObj));
    }

    public static String toLocaleTimeString(Context context, Scriptable thisObj, Object[] args, Function function) {
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getWebWindow().getWebClient().getBrowserVersion();
        String formatString = browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_LOCALE_TIME_WITH_SPECIAL_CHARS) ? "\u200eHH\u200e:\u200emm\u200e:\u200ess" : "HH:mm:ss";
        FastDateFormat format = FastDateFormat.getInstance((String)formatString, (Locale)DateCustom.getLocale(thisObj));
        return format.format(DateCustom.getDateValue(thisObj));
    }

    public static String toUTCString(Context context, Scriptable thisObj, Object[] args, Function function) {
        Date date = new Date(DateCustom.getDateValue(thisObj));
        return DateFormatUtils.format((Date)date, (String)"EEE, d MMM yyyy HH:mm:ss z", (TimeZone)UTC_TIME_ZONE, (Locale)Locale.ENGLISH);
    }

    private static long getDateValue(Scriptable thisObj) {
        try {
            if (DATE_FIELD_ == null) {
                DATE_FIELD_ = thisObj.getClass().getDeclaredField("date");
                DATE_FIELD_.setAccessible(true);
            }
            return ((Double)DATE_FIELD_.get(thisObj)).longValue();
        }
        catch (Exception e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    private static Locale getLocale(Scriptable thisObj) {
        BrowserVersion broserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        return new Locale(broserVersion.getSystemLanguage());
    }
}

