/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.ImageData;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLImageElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class CanvasRenderingContext2D
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(CanvasRenderingContext2D.class);
    private final HTMLCanvasElement canvas_;
    private final BufferedImage image_;
    private final Graphics2D graphics2D_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public CanvasRenderingContext2D() {
        this.canvas_ = null;
        this.image_ = null;
        this.graphics2D_ = null;
    }

    public CanvasRenderingContext2D(HTMLCanvasElement canvas) {
        this.canvas_ = canvas;
        this.image_ = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 1);
        this.graphics2D_ = this.image_.createGraphics();
    }

    @JsxGetter
    public Object getFillStyle() {
        return null;
    }

    @JsxSetter
    public void setFillStyle(String fillStyle) {
        fillStyle = fillStyle.replaceAll("\\s", "");
        Color color = null;
        if (fillStyle.startsWith("rgb(")) {
            String[] colors = fillStyle.substring(4, fillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        } else if (fillStyle.startsWith("rgba(")) {
            String[] colors = fillStyle.substring(5, fillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), (int)(Float.parseFloat(colors[3]) * 255.0f));
        } else if (fillStyle.startsWith("#")) {
            color = Color.decode(fillStyle);
        } else {
            try {
                Field f = Color.class.getField(fillStyle);
                color = (Color)f.get(null);
            }
            catch (Exception e) {
                LOG.info((Object)("Can not find color '" + fillStyle + '\''));
                color = Color.black;
            }
        }
        this.graphics2D_.setColor(color);
    }

    @JsxGetter
    public Object getStrokeStyle() {
        return null;
    }

    @JsxSetter
    public void setStrokeStyle(Object strokeStyle) {
    }

    @JsxGetter
    public double getLineWidth() {
        return 0.0;
    }

    @JsxSetter
    public void setLineWidth(Object lineWidth) {
    }

    @JsxGetter
    public double getGlobalAlpha() {
        return 0.0;
    }

    @JsxSetter
    public void setGlobalAlpha(Object globalAlpha) {
    }

    @JsxFunction
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
    }

    @JsxFunction
    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
    }

    @JsxFunction
    public void beginPath() {
    }

    @JsxFunction
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
    }

    @JsxFunction
    public void clearRect(double x, double y, double w, double h) {
    }

    @JsxFunction
    public void clip() {
    }

    @JsxFunction
    public void closePath() {
    }

    @JsxFunction
    public void createImageData() {
    }

    @JsxFunction
    public void createLinearGradient(double x0, double y0, double r0, double x1, Object y1, Object r1) {
    }

    @JsxFunction
    public void createPattern() {
    }

    @JsxFunction
    public void createRadialGradient() {
    }

    @JsxFunction
    public void drawImage(Object image, int sx, int sy, Object sWidth, Object sHeight, Object dx, Object dy, Object dWidth, Object dHeight) {
        Integer dyI;
        Integer dxI;
        Integer dWidthI = null;
        Integer dHeightI = null;
        Integer sWidthI = null;
        Integer sHeightI = null;
        if (dx != Undefined.instance) {
            dxI = ((Number)dx).intValue();
            dyI = ((Number)dy).intValue();
            dWidthI = ((Number)dWidth).intValue();
            dHeightI = ((Number)dHeight).intValue();
        } else {
            dxI = sx;
            dyI = sy;
        }
        if (sWidth != Undefined.instance) {
            sWidthI = ((Number)sWidth).intValue();
            sHeightI = ((Number)sHeight).intValue();
        }
        try {
            ImageReader imageReader;
            if (image instanceof HTMLImageElement && (imageReader = ((HtmlImage)((HTMLImageElement)image).getDomNodeOrDie()).getImageReader()).getNumImages(true) != 0) {
                BufferedImage img = imageReader.read(0);
                this.graphics2D_.drawImage((Image)img, dxI, (int)dyI, null);
            }
        }
        catch (IOException ioe) {
            throw Context.throwAsScriptRuntimeEx(ioe);
        }
    }

    public String toDataURL(String type) {
        try {
            if (type == null) {
                type = "png";
            }
            return "data:" + type + ";base64," + CanvasRenderingContext2D.encodeToString(this.image_, type);
        }
        catch (IOException ioe) {
            throw Context.throwAsScriptRuntimeEx(ioe);
        }
    }

    private static String encodeToString(BufferedImage image, String type) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, type, bos);
            byte[] imageBytes = bos.toByteArray();
            String string = new String(new Base64().encode(imageBytes));
            return string;
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME)})
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
    }

    @JsxFunction
    public void fill() {
    }

    @JsxFunction
    public void fillRect(int x, int y, int w, int h) {
        this.graphics2D_.fillRect(x, y, w, h);
    }

    @JsxFunction
    public void fillText() {
    }

    @JsxFunction
    public ImageData getImageData(int sx, int sy, int sw, int sh) {
        ImageData imageData = new ImageData(this.image_, sx, sy, sw, sh);
        imageData.setParentScope(this.getParentScope());
        imageData.setPrototype(this.getPrototype(imageData.getClass()));
        return imageData;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=31.0f), @WebBrowser(value=BrowserName.CHROME)})
    public void getLineDash() {
    }

    @JsxFunction
    public void getLineData() {
    }

    @JsxFunction
    public void isPointInPath() {
    }

    @JsxFunction
    public void lineTo(double x, double y) {
    }

    @JsxFunction
    public void measureText() {
    }

    @JsxFunction
    public void moveTo(double x, double y) {
    }

    @JsxFunction
    public void putImageData() {
    }

    @JsxFunction
    public void quadraticCurveTo(double controlPointX, double controlPointY, double endPointX, double endPointY) {
    }

    @JsxFunction
    public void rect() {
    }

    @JsxFunction
    public void restore() {
    }

    @JsxFunction
    public void rotate() {
    }

    @JsxFunction
    public void save() {
    }

    @JsxFunction
    public void scale(Object x, Object y) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=31.0f), @WebBrowser(value=BrowserName.CHROME)})
    public void setLineDash() {
    }

    @JsxFunction
    public void setTransform() {
    }

    @JsxFunction
    public void stroke() {
    }

    @JsxFunction
    public void strokeRect(double x, double y, double w, double h) {
    }

    @JsxFunction
    public void strokeText() {
    }

    @JsxFunction
    public void transform() {
    }

    @JsxFunction
    public void translate(Object x, Object y) {
    }

    @JsxGetter
    public HTMLCanvasElement getCanvas() {
        return this.canvas_;
    }
}

