/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.test.WarExploder;

public class TestPluginManager
extends PluginManager {
    public static final PluginManager INSTANCE;
    private static final Logger LOGGER;

    private TestPluginManager() throws IOException {
        super(null, Util.createTempDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> loadBundledPlugins() throws Exception {
        URL index;
        HashSet<String> names = new HashSet<String>();
        File bundledPlugins = new File(WarExploder.getExplodedDir(), "WEB-INF/plugins");
        File[] children = bundledPlugins.listFiles();
        if (children == null) {
            throw new Error("Unable to find " + bundledPlugins);
        }
        for (File child : children) {
            try {
                names.add(child.getName());
                this.copyBundledPlugin(child.toURI().toURL(), child.getName());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + child, e);
            }
        }
        URL u = ((Object)((Object)this)).getClass().getClassLoader().getResource("the.jpl");
        if (u == null) {
            u = ((Object)((Object)this)).getClass().getClassLoader().getResource("the.hpl");
        }
        if (u != null) {
            try {
                names.add("the.jpl");
                this.copyBundledPlugin(u, "the.jpl");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to copy the.jpl", e);
            }
        }
        if ((index = ((Object)((Object)this)).getClass().getResource("/test-dependencies/index")) != null) {
            BufferedReader r = new BufferedReader(new InputStreamReader(index.openStream(), "UTF-8"));
            try {
                String line;
                while ((line = r.readLine()) != null) {
                    URL url = new URL(index, line + ".jpi");
                    File f = new File(url.toURI());
                    if (f.exists()) {
                        this.copyBundledPlugin(url, line + ".jpi");
                        continue;
                    }
                    this.copyBundledPlugin(new URL(index, line + ".hpi"), line + ".jpi");
                }
            }
            finally {
                r.close();
            }
        }
        return names;
    }

    public void stop() {
        for (PluginWrapper p : this.activePlugins) {
            p.stop();
        }
    }

    private void reallyStop() {
        super.stop();
    }

    static {
        LOGGER = Logger.getLogger(TestPluginManager.class.getName());
        try {
            INSTANCE = new TestPluginManager();
            Runtime.getRuntime().addShutdownHook(new Thread("delete " + TestPluginManager.INSTANCE.rootDir){

                @Override
                public void run() {
                    ((TestPluginManager)INSTANCE).reallyStop();
                    System.gc();
                    try {
                        Util.deleteRecursive((File)TestPluginManager.INSTANCE.rootDir);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

