/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.acegisecurity.acls.sid.Sid;

public class MockAuthorizationStrategy
extends AuthorizationStrategy {
    private final List<Grant.GrantOn.GrantOnTo> grantsOnTo = new ArrayList<Grant.GrantOn.GrantOnTo>();

    public Grant grant(Permission ... permissions) {
        HashSet<Permission> effective = new HashSet<Permission>(Arrays.asList(permissions));
        boolean added = true;
        while (added) {
            added = false;
            for (Permission p : Permission.getAll()) {
                added |= effective.contains(p.impliedBy) && effective.add(p);
            }
        }
        return new Grant(effective);
    }

    public Grant grantWithoutImplication(Permission ... permissions) {
        return new Grant(new HashSet<Permission>(Arrays.asList(permissions)));
    }

    @NonNull
    public ACL getRootACL() {
        return new ACLImpl("");
    }

    @NonNull
    public ACL getACL(AbstractItem item) {
        return new ACLImpl(item.getFullName());
    }

    @NonNull
    public ACL getACL(@NonNull Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    @NonNull
    public Collection<String> getGroups() {
        return Collections.emptySet();
    }

    private class ACLImpl
    extends SidACL {
        private final String path;

        ACLImpl(String path) {
            this.path = path;
        }

        protected Boolean hasPermission(Sid p, Permission permission) {
            String name = this.toString(p);
            for (Grant.GrantOn.GrantOnTo grantOnTo : MockAuthorizationStrategy.this.grantsOnTo) {
                if (!grantOnTo.matches(this.path, name, permission)) continue;
                return true;
            }
            return null;
        }
    }

    public class Grant {
        private final Set<String> permissions;

        Grant(Set<Permission> permissions) {
            this.permissions = permissions.stream().map(Permission::getId).collect(Collectors.toSet());
        }

        public GrantOn everywhere() {
            return this.onPaths(".*");
        }

        public GrantOn onRoot() {
            return this.onPaths("");
        }

        public GrantOn onItems(Item ... items) {
            String[] paths = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                paths[i] = Pattern.quote(items[i].getFullName());
            }
            return this.onPaths(paths);
        }

        public GrantOn onFolders(ItemGroup<?> ... folders) {
            String[] paths = new String[folders.length];
            for (int i = 0; i < folders.length; ++i) {
                paths[i] = Pattern.quote(folders[i].getFullName()) + "(|/.+)";
            }
            return this.onPaths(paths);
        }

        public GrantOn onPaths(String ... pathRegexps) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (String rx : pathRegexps) {
                if (first) {
                    first = false;
                } else {
                    b.append('|');
                }
                b.append("(?:").append(rx).append(')');
            }
            return new GrantOn(b.toString());
        }

        public class GrantOn {
            private final Pattern regexp;

            GrantOn(String regexp) {
                this.regexp = Pattern.compile(regexp);
            }

            public MockAuthorizationStrategy to(String ... sids) {
                return new GrantOnTo(new HashSet<String>(Arrays.asList(sids))).add();
            }

            public MockAuthorizationStrategy to(User ... users) {
                String[] sids = new String[users.length];
                for (int i = 0; i < users.length; ++i) {
                    sids[i] = users[i].getId();
                }
                return this.to(sids);
            }

            public MockAuthorizationStrategy toEveryone() {
                return this.to("role_everyone");
            }

            public MockAuthorizationStrategy toAuthenticated() {
                return this.to("authenticated");
            }

            private class GrantOnTo {
                private final Set<String> sids;

                GrantOnTo(Set<String> sids) {
                    this.sids = sids;
                }

                MockAuthorizationStrategy add() {
                    MockAuthorizationStrategy.this.grantsOnTo.add(this);
                    return MockAuthorizationStrategy.this;
                }

                boolean matches(String path, String name, Permission permission) {
                    return GrantOn.this.regexp.matcher(path).matches() && this.sids.contains(name) && Grant.this.permissions.contains(permission.getId());
                }
            }
        }
    }
}

