/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Request;

final class Response<RSP, EXC extends Throwable>
extends Command {
    private final int id;
    private int lastIoId;
    final RSP returnValue;
    final EXC exception;
    private static final long serialVersionUID = 1L;

    Response(int id, int lastIoId, RSP returnValue) {
        this.id = id;
        this.lastIoId = lastIoId;
        this.returnValue = returnValue;
        this.exception = null;
    }

    Response(int id, int lastIoId, EXC exception) {
        this.id = id;
        this.lastIoId = lastIoId;
        this.returnValue = null;
        this.exception = exception;
    }

    @Override
    protected void execute(Channel channel) {
        Request<?, ?> req = channel.pendingCalls.get(this.id);
        if (req == null) {
            return;
        }
        req.responseIoId = this.lastIoId;
        req.onCompleted(this);
        channel.pendingCalls.remove(this.id);
    }

    public String toString() {
        return "Response[retVal=" + Response.toString(this.returnValue) + ",exception=" + Response.toString(this.exception) + "]";
    }

    private static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }
}

